/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.visualeditor;

import com.ecc.ide.editor.Wrapper;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.visualeditor.Messages;
import com.ecc.ide.visualeditor.VisualEditorInterface;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class VisualEditorContentViewer
extends Composite
implements VisualEditorInterface {
    private Vector visualElements = new Vector();
    protected EditorProfile profile;
    private VisualElementWrapper rootWrapper;
    private Composite contentComposite;

    public VisualEditorContentViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this, 2816);
        scrolledComposite.setBackground(Display.getCurrent().getSystemColor(1));
        scrolledComposite.setLayout((Layout)new FillLayout());
        this.contentComposite = new Composite((Composite)scrolledComposite, 0);
        this.contentComposite.setBackground(Display.getCurrent().getSystemColor(1));
        this.contentComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (VisualEditorContentViewer.this.rootWrapper != null) {
                    VisualEditorContentViewer.this.rootWrapper.paintControl(e.gc, 0, 0);
                }
            }
        });
        this.contentComposite.setSize(500, 375);
        scrolledComposite.setContent((Control)this.contentComposite);
    }

    public void setEditorProfile(EditorProfile profile) {
        this.profile = profile;
    }

    public void setXMLContent(XMLNode node) throws Exception {
        try {
            VisualElementWrapper wrapper;
            Element element = this.profile.getElement(node.getNodeName());
            if (element == null) {
                String msg = String.valueOf(Messages.getString("VisualEditorContentViewer.Element_named__1")) + node.getNodeName() + Messages.getString("VisualEditorContentViewer._not_found_in_editor_profile_of__2") + this.profile.getTitle();
                msg = String.valueOf(msg) + Messages.getString("VisualEditorContentViewer._nPlease_make_sure_to_define_such_element_via_the_profile_editor_!_3");
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("VisualEditorContentViewer.Error_4"), (String)msg);
                return;
            }
            if (element.getWrapperClassType() == null) {
                wrapper = new VisualElementWrapper(null, node, this.profile);
            } else {
                wrapper = (VisualElementWrapper)Class.forName(element.getWrapperClassType()).newInstance();
                wrapper.setElement(element);
                wrapper.setXMLNode(node);
            }
            wrapper.editor = this;
            this.visualElements.addElement(wrapper);
            this.rootWrapper = wrapper;
            Rectangle rect = wrapper.getRectangle();
            this.contentComposite.setSize(rect.width, rect.height);
            this.addViewElementToContent(wrapper, node);
            this.redraw();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadXMLContent(InputStream in) throws Exception {
        try {
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode node = (XMLNode)xmlLoader.loadXMLContent(in);
            this.setXMLContent(node);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void loadXMLFile(String xmlFileName) {
        try {
            FileInputStream fi = new FileInputStream(xmlFileName);
            this.loadXMLContent(fi);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addViewElementToContent(VisualElementWrapper wrapper, XMLNode node) {
        Vector childs = node.getChilds();
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            Element element = this.profile.getElement(aNode.getNodeName());
            if (element != null) {
                VisualElementWrapper aWrapper = null;
                if (element.getWrapperClassType() == null) {
                    aWrapper = new VisualElementWrapper(wrapper, aNode, this.profile);
                } else {
                    try {
                        aWrapper = (VisualElementWrapper)Class.forName(element.getWrapperClassType()).newInstance();
                        aWrapper.setElement(element);
                        aWrapper.setParent(wrapper);
                        aWrapper.setXMLNode(aNode);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                aWrapper.editor = this;
                this.visualElements.addElement(aWrapper);
                this.addViewElementToContent(aWrapper, aNode);
            }
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public VisualElementWrapper getActivateVisualElement() {
        return null;
    }

    public VisualElementWrapper getRootElement() {
        return this.rootWrapper;
    }

    public void showStateMessage(String msg) {
    }

    public void showPosition(Rectangle resizeRect) {
    }

    public VisualElementWrapper getVisualElement(int x, int y) {
        return null;
    }

    public VisualElementWrapper addNewElement(VisualElementWrapper wrapper, Element element, int x, int y) {
        return null;
    }

    public void doLink(VisualElementWrapper src, VisualElementWrapper dst) {
    }

    public void removeElement(VisualElementWrapper wrapper) {
    }

    public void adjustTabOrder(VisualElementWrapper wrapper, int order) {
    }

    public double getXResolution() {
        return 0.0;
    }

    public double getYResolution() {
        return 0.0;
    }

    public void updateContent() {
    }

    public boolean isValidName(String name) {
        return true;
    }

    public VisualElementWrapper getVisualElementNamed(String name) {
        int size = this.visualElements.size();
        if (size == 0) {
            return null;
        }
        int i = size - 1;
        while (i >= 0) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.visualElements.elementAt(i);
            if (name.equals(wrapper.getAttrValue("name"))) {
                return wrapper;
            }
            --i;
        }
        return null;
    }

    public EditorProfile getEditorProfile() {
        return this.profile;
    }

    public void setActivateWrapper(Wrapper wrapper) {
    }

    public void deleteWrapper(Wrapper wrapper) {
    }

    public void doInsert(Element element) {
    }

    public void cancelCurrentAction() {
    }

    public void deleteActivateComponent() {
    }

    public String getRootPath() {
        return null;
    }

    public void setItemEnable(int item, boolean value) {
    }

    public String getStringContent() {
        return null;
    }
}

