/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.visualeditor;

import com.ecc.ide.editor.Wrapper;
import com.ecc.ide.editor.WrapperOwner;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.visualflow.VisualFlowFramePanel;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementChild;
import com.ecc.ide.visualeditor.VisualEditorFramePanel;
import com.ecc.ide.visualeditor.VisualEditorInterface;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

public class VisualElementWrapper
implements Wrapper {
    int borderWidth = 5;
    public int x;
    public int y;
    public int width;
    public int height;
    public VisualEditorInterface editor;
    protected VisualElementWrapper parentWrapper;
    public Vector childs = new Vector(10);
    protected boolean isShow = true;
    protected boolean isActivated = false;
    public boolean isSelected = false;
    private boolean moveable = true;
    private boolean resizeable = true;
    private int resizeMode = 0;
    private int tabOrder;
    private boolean isSetTabOrder = false;
    private boolean hasSetTabOrder = false;
    private String objectName;
    private Object beanTreeObj;
    protected Element element;
    public XMLNode node;
    protected WrapperOwner owner;
    private String imageFileName;
    private Image image;

    public Object getWrappedObject() {
        return this.node;
    }

    public void setWrappedObject(Object obj) {
        this.node = (XMLNode)obj;
    }

    public boolean getResizeable() {
        return this.resizeable;
    }

    public void setResizable(boolean value) {
        this.resizeable = value;
    }

    public int getResizeMode() {
        return this.resizeMode;
    }

    public void setResizeMode(int value) {
        this.resizeMode = value;
    }

    public void setMoveable(boolean value) {
        this.moveable = value;
    }

    public boolean getMoveable() {
        return this.moveable;
    }

    public void setIsShow(boolean value) {
        this.isShow = value;
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.childs.elementAt(i);
            wrapper.setIsShow(value);
            ++i;
        }
    }

    public boolean getIsShow() {
        return this.isShow;
    }

    public void setIsSelected(boolean value) {
        this.isSelected = value;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public VisualElementWrapper() {
    }

    public void setParent(VisualElementWrapper pWrapper) {
        this.parentWrapper = pWrapper;
        if (pWrapper != null) {
            pWrapper.addChild(this);
        }
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public void setXMLNode(XMLNode node) {
        this.node = node;
        this.width = 50;
        this.height = 25;
        this.x = node.getIntAttrValue("x");
        this.y = node.getIntAttrValue("y");
        this.width = node.getIntAttrValue("width");
        this.height = node.getIntAttrValue("height");
        if (this.width == 0) {
            this.width = 50;
        }
        if (this.height == 0) {
            this.height = 25;
        }
        this.objectName = node.getAttrValue("name");
        if (this.objectName == null) {
            this.objectName = this.element.getObjectName();
        }
    }

    public VisualElementWrapper(VisualElementWrapper pWrapper, XMLNode node, EditorProfile profile) {
        this.node = node;
        this.width = 50;
        this.height = 25;
        try {
            this.x = Integer.parseInt(node.getAttrValue("x"));
            this.y = Integer.parseInt(node.getAttrValue("y"));
            this.width = Integer.parseInt(node.getAttrValue("width"));
            this.height = Integer.parseInt(node.getAttrValue("height"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parentWrapper = pWrapper;
        if (pWrapper != null) {
            this.parentWrapper.addChild(this);
        }
        this.element = profile.getElement(node.getNodeName());
        this.element.setProfile(profile);
        this.objectName = node.getAttrValue("name");
        if (this.objectName == null && this.element != null) {
            this.objectName = this.element.getObjectName();
            node.setAttrValue("name", this.objectName);
        }
    }

    public XMLNode getXMLNode() {
        return this.node;
    }

    public String getObjectName() {
        if (this.objectName != null) {
            return this.objectName;
        }
        return " ";
    }

    public void setObjectName(String objName) {
        this.objectName = objName;
    }

    public void setBounds(Rectangle rect) {
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        int x1 = this.x;
        int y1 = this.y;
        int w1 = this.width;
        int h1 = this.height;
        Rectangle rec = new Rectangle(0, 0, 10, 10);
        if (this.getParentWrapper() != null) {
            Rectangle rec1 = this.getParentWrapper().getRectangle();
            rec.x = rec1.x;
            rec.y = rec1.y;
        }
        this.x = x - rec.x;
        this.y = y - rec.y;
        this.width = width;
        this.height = height;
        if (x1 == this.x && y1 == this.y && h1 == this.height && w1 == this.width) {
            return;
        }
        this.node.setAttrValue("x", String.valueOf(this.x));
        this.node.setAttrValue("y", String.valueOf(this.y));
        this.node.setAttrValue("width", String.valueOf(width));
        this.node.setAttrValue("height", String.valueOf(height));
    }

    public String getAttrValue(String attrName) {
        String value = null;
        if (this.node != null) {
            value = this.node.getAttrValue(attrName);
        }
        return value;
    }

    public Element getElement() {
        return this.element;
    }

    public Point getSize() {
        return new Point(this.width, this.height);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.node.setAttrValue("width", String.valueOf(width));
        this.node.setAttrValue("height", String.valueOf(height));
    }

    public void paintControl(GC gc, int xOffset, int yOffset) {
        if (!this.isShow) {
            return;
        }
        int x = this.x + xOffset;
        int y = this.y + yOffset;
        Rectangle parentClipRect = gc.getClipping();
        this.paintBackGroundImage(gc, x, y);
        if (this.editor == null || this != this.editor.getRootElement()) {
            Rectangle clipRect = this.clipRect(this.getRectangle(), parentClipRect);
            gc.setClipping(clipRect);
        }
        Color bkColor = gc.getBackground();
        gc.setForeground(Display.getDefault().getSystemColor(2));
        String fieldName = this.element.getVisualType();
        if (fieldName == null) {
            fieldName = this.node.getNodeName();
        }
        if (fieldName.equals("Label")) {
            String text = this.node.getAttrValue("text");
            if ((text = this.getExternResource(text)) != null) {
                gc.drawText(text, x + 3, y + 3, 3);
            }
        } else if (fieldName.equals("TextOutArea")) {
            String text = this.node.getAttrValue("nodeValue");
            if (text != null) {
                gc.drawText(text, x + 3, y + 3, 3);
            }
        } else if (fieldName.equals("Button")) {
            this.draw3DRect(gc, x, y, this.width, this.height, 1, Display.getDefault().getSystemColor(22));
            String text = this.node.getAttrValue("text");
            text = this.getExternResource(text);
            if (text != null) {
                gc.setBackground(Display.getDefault().getSystemColor(22));
                gc.setForeground(Display.getDefault().getSystemColor(2));
                int len = text.getBytes().length;
                int xs = (this.width - (len *= 8)) / 2 + x;
                gc.drawText(text, xs, y + (this.height - 16) / 2);
            }
        } else if (fieldName.indexOf("Field") != -1) {
            this.draw3DRect(gc, x, y, this.width, this.height, 0, Display.getDefault().getSystemColor(1));
            gc.setForeground(Display.getDefault().getSystemColor(2));
            if (fieldName.equals("PasswordField")) {
                gc.drawText("******", x + 3, y + (this.height - 16) / 2);
            } else if (fieldName.equals("OutField")) {
                String text = this.getAttrValue("dataName");
                text = text != null ? "=" + text : "Output field";
                gc.drawText(text, x + 3, y + (this.height - 16) / 2);
            }
            gc.setBackground(bkColor);
        } else if (fieldName.equals("Icon")) {
            gc.fillRectangle(x, y, this.width, this.height);
            gc.setForeground(Display.getDefault().getSystemColor(2));
            Image image = this.element.getImage();
            int txtY = y + 3;
            if (image != null) {
                int imWidth = image.getBounds().width;
                gc.drawImage(image, x + (this.width - imWidth) / 2, y + 3);
                txtY = txtY + image.getBounds().height + 2;
            }
            gc.drawText(this.node.getAttrValue("name"), x + 3, txtY);
            gc.drawRectangle(x, y, this.width, this.height);
        } else if (fieldName.equals("IconLabel")) {
            gc.fillRectangle(x, y, this.width, this.height);
            gc.setForeground(Display.getDefault().getSystemColor(2));
            Image image = this.element.getImage();
            int txtX = x + 3;
            if (image != null) {
                int imWidth = image.getBounds().width;
                gc.drawImage(image, x + 1, y + 3);
                txtX = txtX + image.getBounds().width + 2;
            }
            String text = this.node.getAttrValue("label");
            if ((text = this.getExternResource(text)) != null) {
                gc.drawText(text, txtX, y + 3, 3);
            }
        } else if (fieldName.equals("ComboBox")) {
            this.draw3DRect(gc, x, y, this.width, this.height, 0, Display.getDefault().getSystemColor(1));
            this.draw3DRect(gc, x + this.width - (this.height - 6) - 2, y + 2, this.height - 6, this.height - 4, 1, Display.getDefault().getSystemColor(22));
            gc.setForeground(Display.getDefault().getSystemColor(2));
            int x0 = x + this.width - (this.height - 6) / 2 - 3;
            int y0 = y + this.height / 2 + 1;
            gc.drawLine(x0, y0 + 1, x0, y0 + 1);
            gc.drawLine(x0 - 1, y0, x0 + 1, y0);
            gc.drawLine(x0 - 2, y0 - 1, x0 + 2, y0 - 1);
            gc.drawLine(x0 - 3, y0 - 2, x0 + 3, y0 - 2);
        } else {
            gc.setForeground(Display.getDefault().getSystemColor(2));
            gc.drawRectangle(x, y, this.width, this.height);
        }
        if (this.isActivated) {
            this.paintActivateSymbol(gc, xOffset, yOffset);
        }
        if (this.isSelected) {
            this.paintSelectedSymbol(gc, xOffset, yOffset);
        }
        if (this.getParentWrapper() != null && this.getParentWrapper().getIsSetTabOrder()) {
            this.paintTabOrderSymbol(gc, xOffset, yOffset);
        }
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.childs.elementAt(i);
            wrapper.paintControl(gc, x, y);
            ++i;
        }
        gc.setBackground(bkColor);
        gc.setClipping(parentClipRect);
    }

    public String getExternResource(String resId) {
        if (resId == null) {
            return resId;
        }
        if (!resId.startsWith("@")) {
            return resId;
        }
        XMLNode externResourceNode = this.getWrapperOwner().getExternResource();
        if (externResourceNode != null) {
            XMLNode resNode = externResourceNode.findChildNode(resId.substring(1));
            if (resNode == null) {
                return resId;
            }
            Locale locale = Locale.getDefault();
            String localeStr = locale.toString();
            XMLNode node = resNode.findChildNode(localeStr);
            if (node == null) {
                node = resNode.getFirstNode();
            }
            if (node != null) {
                return node.getNodeValue();
            }
            return resId;
        }
        return resId;
    }

    protected Rectangle clipRect(Rectangle src, Rectangle dst) {
        int x = src.x - this.borderWidth;
        int y = src.y - this.borderWidth;
        int width = src.width + 2 * this.borderWidth;
        int height = src.height + 2 * this.borderWidth;
        if (x < dst.x) {
            x = dst.x;
        }
        if (y < dst.y) {
            y = dst.y;
        }
        if (x + width > dst.x + dst.width) {
            width = dst.width + dst.x - x;
        }
        if (y + height > dst.y + dst.height) {
            height = dst.height + dst.y - y;
        }
        return new Rectangle(x, y, width, height);
    }

    public void setBeanTreeObject(Object obj) {
        this.beanTreeObj = obj;
    }

    public Object getBeanTreeObject() {
        return this.beanTreeObj;
    }

    public void setActivated(boolean bAct) {
        this.isActivated = bAct;
        if (this.parentWrapper != null) {
            this.parentWrapper.childActivated(this, bAct);
        }
    }

    public void childActivated(VisualElementWrapper child, boolean value) {
    }

    private void setControlAttrValue() {
        Hashtable attrs = this.node.getAttrs();
        try {
            Enumeration attrKeys = attrs.keys();
            while (attrKeys.hasMoreElements()) {
                String key = (String)attrKeys.nextElement();
                String value = (String)attrs.get(key);
                if ("x".equals(key) || "y".equals(key) || "width".equals(key) || "height".endsWith(key) || "name".equals(key)) continue;
                this.setAttrValue(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setAttrValue(String key, Object value) {
        if ("name".equals(key)) {
            if (value == null || value.toString().length() == 0) {
                return;
            }
            if (this.editor != null && !this.editor.isValidName(value.toString())) {
                return;
            }
            if (this.beanTreeObj != null && this.beanTreeObj instanceof TreeItem) {
                ((TreeItem)this.beanTreeObj).setText(value.toString());
            }
            this.node.setAttrValue(key, value.toString());
            if (this.editor != null) {
                this.editor.updateContent();
            }
        } else {
            if (value == null) {
                this.node.setAttrValue(key, null);
            } else {
                this.node.setAttrValue(key, value.toString());
            }
            if (this.editor != null) {
                this.editor.updateContent();
            }
        }
    }

    public void addChild(VisualElementWrapper child) {
        this.childs.addElement(child);
        child.setTabOrder(this.childs.size() - 1);
    }

    public void removeChild(VisualElementWrapper child) {
        this.childs.remove(child);
        this.node.remove(child.getXMLNode());
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.childs.elementAt(i);
            wrapper.setTabOrder(i);
            ++i;
        }
    }

    public Rectangle getRectangle() {
        int xOffset = this.x;
        int yOffset = this.y;
        VisualElementWrapper wrapper = this.parentWrapper;
        while (wrapper != null) {
            xOffset += wrapper.x;
            yOffset += wrapper.y;
            wrapper = wrapper.getParentWrapper();
        }
        return new Rectangle(xOffset, yOffset, this.width, this.height);
    }

    public VisualElementWrapper getParentWrapper() {
        return this.parentWrapper;
    }

    public boolean isAcceptable(Element anElement) {
        if (anElement == null) {
            return false;
        }
        if (this.element.getChilds() == null || this.element.getChilds().size() == 0) {
            return false;
        }
        try {
            VisualFlowFramePanel flowPanel = (VisualFlowFramePanel)this.editor;
            if (!flowPanel.isMainFlow() && "flow".equals(this.node.getNodeName())) {
                return false;
            }
        }
        catch (Exception flowPanel) {
            // empty catch block
        }
        int i = 0;
        while (i < this.element.getChilds().size()) {
            ElementChild child = (ElementChild)this.element.getChilds().elementAt(i);
            if (child.getChildElementId().equals(anElement.getElementName())) {
                String countStr = child.getAlowCount();
                if ("*".equals(countStr)) {
                    return true;
                }
                if (this.childs.size() == 0) {
                    return true;
                }
                try {
                    int allowCount = Integer.parseInt(countStr);
                    int existCount = this.getExistChildCount(anElement.getElementName());
                    return existCount < allowCount;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return false;
    }

    protected int getExistChildCount(String elementName) {
        int count = 0;
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.childs.elementAt(i);
            if (wrapper.getElement().getElementName().equals(elementName)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    protected void paintTabOrderSymbol(GC gc, int xOff, int yOff) {
        int offset = 5;
        int delta = 16;
        int x = this.x + xOff;
        int y = this.y + yOff;
        Color bkColor = gc.getBackground();
        if (this.hasSetTabOrder) {
            gc.setBackground(Display.getDefault().getSystemColor(11));
        } else {
            gc.setBackground(Display.getDefault().getSystemColor(10));
        }
        gc.fillRectangle(x - offset, y - offset, delta, delta);
        gc.setForeground(Display.getDefault().getSystemColor(1));
        String txt = String.valueOf(this.getTabOrder());
        gc.drawText(txt, x - offset + (delta - 8 * txt.length()) / 2, y - offset + 2);
        gc.setBackground(bkColor);
    }

    protected void paintSelectedSymbol(GC gc, int xOff, int yOff) {
        int x = this.x + xOff;
        int y = this.y + yOff;
        Point size = this.getSize();
        int height = size.y - 1;
        int width = this.getSize().x - 1;
        gc.setForeground(Display.getDefault().getSystemColor(2));
        gc.drawRectangle(x - this.borderWidth, y - this.borderWidth, this.borderWidth, this.borderWidth);
        gc.drawRectangle(x + (width - this.borderWidth) / 2, y - this.borderWidth, this.borderWidth, this.borderWidth);
        gc.drawRectangle(x + width, y - this.borderWidth, this.borderWidth, this.borderWidth);
        gc.drawRectangle(x - this.borderWidth, y + (height - this.borderWidth) / 2, this.borderWidth, this.borderWidth);
        gc.drawRectangle(x + width, y + (height - this.borderWidth) / 2, this.borderWidth, this.borderWidth);
        gc.drawRectangle(x - this.borderWidth, y + height, this.borderWidth, this.borderWidth);
        gc.drawRectangle(x + (width - this.borderWidth) / 2, y + height, this.borderWidth, this.borderWidth);
        gc.drawRectangle(x + width, y + height, this.borderWidth, this.borderWidth);
    }

    protected void paintActivateSymbol(GC gc, int xOff, int yOff) {
        int x = this.x + xOff;
        int y = this.y + yOff;
        Point size = this.getSize();
        int height = size.y - 1;
        int width = this.getSize().x - 1;
        Color bkColor = gc.getBackground();
        gc.setBackground(Display.getDefault().getSystemColor(2));
        gc.fillRectangle(x - this.borderWidth, y - this.borderWidth, this.borderWidth, this.borderWidth);
        gc.fillRectangle(x + (width - this.borderWidth) / 2, y - this.borderWidth, this.borderWidth, this.borderWidth);
        gc.fillRectangle(x + width, y - this.borderWidth, this.borderWidth, this.borderWidth);
        gc.fillRectangle(x - this.borderWidth, y + (height - this.borderWidth) / 2, this.borderWidth, this.borderWidth);
        gc.fillRectangle(x + width, y + (height - this.borderWidth) / 2, this.borderWidth, this.borderWidth);
        gc.fillRectangle(x - this.borderWidth, y + height, this.borderWidth, this.borderWidth);
        gc.fillRectangle(x + (width - this.borderWidth) / 2, y + height, this.borderWidth, this.borderWidth);
        gc.fillRectangle(x + width, y + height, this.borderWidth, this.borderWidth);
        gc.setBackground(bkColor);
    }

    public void setTabOrder(int order) {
        this.tabOrder = order;
    }

    public int getTabOrder() {
        return this.tabOrder;
    }

    public void setIsSetTabOrder(boolean value) {
        this.isSetTabOrder = value;
        if (value) {
            int i = 0;
            while (i < this.childs.size()) {
                VisualElementWrapper wrapper = (VisualElementWrapper)this.childs.elementAt(i);
                wrapper.setHasSetTabOrder(false);
                ++i;
            }
        }
    }

    public boolean getIsSetTabOrder() {
        return this.isSetTabOrder;
    }

    private void setHasSetTabOrder(boolean value) {
        this.hasSetTabOrder = value;
    }

    public boolean getIsCanSetTabOrder() {
        return this.childs != null && this.childs.size() > 1;
    }

    public void adjustTabOrder(VisualElementWrapper child, int tabOrder) {
        this.childs.removeElement(child);
        this.childs.insertElementAt(child, tabOrder);
        this.node.adjustNodeOrder(child.getXMLNode(), tabOrder);
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.childs.elementAt(i);
            wrapper.setTabOrder(i);
            ++i;
        }
        child.setHasSetTabOrder(true);
    }

    public boolean isPointIn(int x, int y) {
        Rectangle rec = this.getRectangle();
        return x >= rec.x && x <= rec.x + rec.width && y >= rec.y && y <= rec.y + rec.height;
    }

    public boolean canBeDelete() {
        return true;
    }

    public boolean isCanLinkOut() {
        return false;
    }

    public boolean isCanLinkIn(VisualElementWrapper wrapper) {
        return false;
    }

    public VisualElementWrapper getChildNamed(String name) {
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.childs.elementAt(i);
            String wName = wrapper.getAttrValue("name");
            if (wName.equals(name)) {
                return wrapper;
            }
            ++i;
        }
        return null;
    }

    protected void draw3DRect(GC gc, int x, int y, int width, int height, int upOrDown, Color fillColor) {
        Color bkColor = gc.getBackground();
        gc.setBackground(fillColor);
        gc.fillRectangle(x, y, width, height);
        gc.setForeground(Display.getDefault().getSystemColor(2));
        gc.setBackground(bkColor);
        if (upOrDown == 0) {
            gc.setForeground(Display.getDefault().getSystemColor(18));
            gc.drawLine(x, y, x + width, y);
            gc.drawLine(x, y, x, y + height);
            gc.setForeground(Display.getDefault().getSystemColor(17));
            gc.drawLine(x + 1, y + 1, x + width - 1, y + 1);
            gc.drawLine(x + 1, y + 1, x + 1, y + height - 1);
            gc.setForeground(Display.getDefault().getSystemColor(19));
            gc.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
            gc.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 1);
            gc.setForeground(Display.getDefault().getSystemColor(20));
            gc.drawLine(x, y + height, x + width, y + height);
            gc.drawLine(x + width, y, x + width, y + height);
        } else {
            gc.setForeground(Display.getDefault().getSystemColor(19));
            gc.drawLine(x, y, x + width, y);
            gc.drawLine(x, y, x, y + height);
            gc.setForeground(Display.getDefault().getSystemColor(20));
            gc.drawLine(x + 1, y + 1, x + width - 1, y + 1);
            gc.drawLine(x + 1, y + 1, x + 1, y + height - 1);
            gc.setForeground(Display.getDefault().getSystemColor(18));
            gc.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
            gc.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 1);
            gc.setForeground(Display.getDefault().getSystemColor(17));
            gc.drawLine(x, y + height, x + width, y + height);
            gc.drawLine(x + width, y, x + width, y + height);
        }
    }

    public WrapperOwner getWrapperOwner() {
        return this.owner;
    }

    public void setWrapperOwner(WrapperOwner owner) {
        this.owner = owner;
    }

    private void paintBackGroundImage(GC gc, int x, int y) {
        Image image = this.loadBackGroundImage();
        if (image == null) {
            return;
        }
        Rectangle parentClipRect = gc.getClipping();
        Rectangle clipRect = this.clipRect(this.getRectangle(), parentClipRect);
        gc.setClipping(clipRect);
        String zoomImg = this.node.getAttrValue("zoomImage");
        if ("true".equals(zoomImg)) {
            Rectangle srcRec = image.getBounds();
            Rectangle dstRec = this.getRectangle();
            gc.drawImage(image, 0, 0, srcRec.width, srcRec.height, x, y, dstRec.width, dstRec.height);
        } else {
            gc.drawImage(image, x, y);
        }
        gc.setClipping(parentClipRect);
    }

    private Image loadBackGroundImage() {
        String fileName = this.node.getAttrValue("bkImgFile");
        if (fileName == null || fileName.length() == 0) {
            this.imageFileName = null;
            if (this.image != null) {
                this.image.dispose();
            }
            this.image = null;
            return this.image;
        }
        if (fileName.equals(this.imageFileName)) {
            return this.image;
        }
        try {
            String rootPath = "";
            if (this.editor instanceof VisualEditorFramePanel) {
                rootPath = ((VisualEditorFramePanel)this.editor).getRootPath();
            }
            this.imageFileName = String.valueOf(rootPath) + "/" + fileName;
            FileInputStream fi = new FileInputStream(this.imageFileName);
            this.image = new Image(null, (InputStream)fi);
            fi.close();
            this.imageFileName = fileName;
            return this.image;
        }
        catch (Exception e) {
            return null;
        }
    }
}

