/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.visualeditor;

import com.ecc.ide.editor.Wrapper;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.transaction.DataProvider;
import com.ecc.ide.editor.transaction.DataSelectDialog;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.ProfileObjectMaker;
import com.ecc.ide.visualeditor.Messages;
import com.ecc.ide.visualeditor.VisualEditorFramePanel;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import com.swtdesigner.ResourceManager;
import java.io.FileWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;

public class VisualTellerFramePanel
extends VisualEditorFramePanel {
    private ToolItem addDataItem;
    private Hashtable labelMap = new Hashtable();
    private String acceptableComponentNames;
    private DataProvider dataProvider;
    static /* synthetic */ Class class$0;

    public void setLabelMap(String key, String value) {
        this.labelMap.put(key, value);
    }

    public void setAcceptableComponentNames(String value) {
        this.acceptableComponentNames = value;
    }

    public void setDataProvider(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public VisualTellerFramePanel(Composite parent, int style) {
        super(parent, style);
    }

    private void beginLink() {
        this.workingArea.beginLink();
    }

    public static void main(String[] argv) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText(Messages.getString("VisualTellerFramePanel.Test_Frame_3"));
        VisualTellerFramePanel test = new VisualTellerFramePanel((Composite)shell, 2048);
        try {
            String fileName = "/profiles/srvActionProfile.xml";
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new ProfileObjectMaker());
            EditorProfile profile = (EditorProfile)xmlLoader.loadXMLFile(fileName);
            if (profile != null) {
                test.setEditorProfile(profile);
                test.loadXMLFile("testFlow.xml");
                if (profile.getTitle() != null) {
                    shell.setText(profile.getTitle());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
        try {
            FileWriter fw = new FileWriter("testFlow.xml");
            fw.write(test.getXMLStringContent());
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeElement(VisualElementWrapper wrapper) {
        super.removeElement(wrapper);
        if (wrapper == null) {
            return;
        }
    }

    public void setXMLContent(XMLNode node) throws Exception {
        super.setXMLContent(node);
        this.getRootElement().setMoveable(false);
    }

    public void setActivateWrapper(Wrapper wrapper) {
        super.setActivateWrapper(wrapper);
        String nodeType = wrapper.getElement().getElementName();
        if (this.acceptableComponentNames == null) {
            this.addDataItem.setEnabled(false);
            return;
        }
        if (this.acceptableComponentNames.indexOf(nodeType) != -1) {
            this.addDataItem.setEnabled(true);
        } else {
            this.addDataItem.setEnabled(false);
        }
    }

    private void addDataToForm() {
        Vector selectDatas;
        XMLNode dataDictionary = super.getDataDictionary();
        if (dataDictionary == null) {
            return;
        }
        DataSelectDialog dlg = new DataSelectDialog(this.getShell(), 0);
        dlg.setDataDictionary(dataDictionary);
        if (this.dataProvider != null) {
            dlg.setDatas(this.dataProvider.getDatas());
        }
        if ((selectDatas = (Vector)dlg.open()) != null) {
            this.addDataElementToPanel(selectDatas, this.getActivateVisualElement());
            this.workingArea.saveCurrentAction();
        }
    }

    private void addDataElementToPanel(Vector datas, VisualElementWrapper formWrapper) {
        int i;
        XMLNode viewNode = formWrapper.getXMLNode();
        int x = 10;
        int y = 10;
        int height = 25;
        int space = 5;
        Vector childs = viewNode.getChilds();
        if (childs == null) {
            y = 10;
        } else {
            i = 0;
            while (i < childs.size()) {
                int h;
                XMLNode aNode = (XMLNode)childs.elementAt(i);
                String heightStr = aNode.getAttrValue("y");
                if (heightStr != null && y < (h = Integer.parseInt(heightStr))) {
                    y = h;
                }
                ++i;
            }
            y = y + space + height;
        }
        i = 0;
        while (i < datas.size()) {
            String label;
            XMLNode aNode;
            XMLNode dataNode = (XMLNode)datas.elementAt(i);
            if (!"#text".equals(dataNode.getNodeName()) && dataNode != null && (aNode = this.getViewNode(dataNode.getAttrValue("id"), viewNode)) == null && !dataNode.getNodeName().equals("dataCollection") && (label = dataNode.getAttrValue("label")) != null) {
                int labelLength = label.getBytes().length * 8 + 16;
                XMLNode labelNode = new XMLNode();
                labelNode.setAttrValue("name", this.getObjectName("Label"));
                String labelStr = (String)this.labelMap.get("label");
                if (labelStr == null) {
                    labelStr = "Label";
                }
                labelNode.setNodeName(labelStr);
                labelNode.setAttrValue("text", label);
                labelNode.setAttrValue("dataName", dataNode.getAttrValue("id"));
                labelNode.setAttrValue("x", String.valueOf(10));
                labelNode.setAttrValue("y", String.valueOf(y));
                labelNode.setAttrValue("width", String.valueOf(labelLength));
                labelNode.setAttrValue("height", "25");
                viewNode.add(labelNode);
                this.addNewElement(formWrapper, labelNode);
                x = 10 + labelLength + 15;
                XMLNode textNode = new XMLNode();
                labelStr = (String)this.labelMap.get("text");
                if (labelStr == null) {
                    labelStr = "Text";
                }
                textNode.setNodeName(labelStr);
                textNode.setAttrValue("dataName", dataNode.getAttrValue("id"));
                viewNode.add(textNode);
                int fieldLength = 100;
                if (dataNode.getAttrValue("length") != null) {
                    fieldLength = 8 * Integer.parseInt(dataNode.getAttrValue("length"));
                }
                textNode.setAttrValue("x", String.valueOf(x));
                textNode.setAttrValue("y", String.valueOf(y));
                textNode.setAttrValue("width", String.valueOf(fieldLength));
                textNode.setAttrValue("height", "25");
                textNode.setAttrValue("name", dataNode.getAttrValue("id"));
                this.addNewElement(formWrapper, textNode);
                y = y + height + space;
            }
            ++i;
        }
        viewNode.setAttrValue("height", String.valueOf(y));
        this.workingArea.redraw();
    }

    private XMLNode getViewNode(String dataName, XMLNode node) {
        Vector childs = node.getChilds();
        if (childs == null) {
            return null;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            String aDataName = aNode.getAttrValue("dataName");
            if (aDataName != null && aDataName.equals(dataName)) {
                return aNode;
            }
            XMLNode subNode = this.getViewNode(dataName, aNode);
            if (subNode != null) {
                return subNode;
            }
            ++i;
        }
        return null;
    }

    public void createToolItems() {
        ToolItem saveAsTempleteToolItem = new ToolItem(this.toolBar, 8);
        saveAsTempleteToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualTellerFramePanel.this.saveAsTemplete();
            }
        });
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        saveAsTempleteToolItem.setImage(ResourceManager.getImage(clazz, "/images/saveAsTemplete.gif"));
        saveAsTempleteToolItem.setToolTipText(Messages.getString("VisualTellerFramePanel.Save_as_Templete_1"));
        ToolItem toolItem_10 = new ToolItem(this.toolBar, 2);
        this.addDataItem = new ToolItem(this.toolBar, 8);
        this.addDataItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualTellerFramePanel.this.addDataToForm();
            }
        });
        this.addDataItem.setToolTipText(Messages.getString("VisualTellerFramePanel.add_Data_Element_to_Panel_1"));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addDataItem.setImage(ResourceManager.getImage(clazz2, "/images/addDataToForm.gif"));
        ToolItem toolItem_11 = new ToolItem(this.toolBar, 2);
        super.createToolItems();
    }

    private void saveAsTemplete() {
        if (this.getRootElement() == null) {
            return;
        }
        FileDialog fileDlg = new FileDialog(this.getShell(), 8192);
        String aFileName = fileDlg.open();
        if (aFileName == null) {
            return;
        }
        try {
            String tmp = aFileName.toLowerCase();
            if (!tmp.endsWith(".xml")) {
                aFileName = String.valueOf(aFileName) + ".xml";
            }
            FileWriter fw = new FileWriter(aFileName);
            fw.write(this.getXMLStringContent());
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

