/*
 * Decompiled with CFR 0.152.
 */
package com.msyd.gateway.converter;

import com.msds.dealAgentCollPay.bean.CP0001or3_MsgBody;
import com.msds.dealAgentCollPay.bean.CP0002or4_MsgBody;
import com.msds.dealAgentCollPay.bean.CP0002or4_MsgInfo;
import com.msds.dealAgentCollPay.bean.CP0006_MsgBody;
import com.msds.dealAgentCollPay.bean.CP0006_MsgInfo;
import com.msds.dealAgentCollPay.bean.CP0020_MsgBody;
import com.msds.dealAgentCollPay.bean.CP0020or21_MsgInfo;
import com.msds.dealAgentCollPay.bean.CP0021_MsgBody;
import com.msds.dealAgentCollPay.bean.CP0022To25_MsgInfo;
import com.msds.dealAgentCollPay.bean.CP0022_MsgBody;
import com.msds.dealAgentCollPay.bean.CP0023_MsgBody;
import com.msds.dealAgentCollPay.bean.CP0024_MsgBody;
import com.msds.dealAgentCollPay.bean.CP0025_MsgBody;
import com.msds.dealAgentCollPay.bean.CP0028_MsgBody;
import com.msds.dealAgentCollPay.bean.CP0028_MsgInfo;
import com.msds.dealAgentCollPay.bean.CP0029_MsgBody;
import com.msds.dealAgentCollPay.bean.CP0030_MsgBody;
import com.msds.dealAgentCollPay.bean.CP0031_MsgBody;
import com.msds.dealAgentCollPay.bean.CP0032_MsgBody;
import com.msds.dealAgentCollPay.bean.CP0032_MsgInfo;
import com.msds.dealAgentCollPay.bean.MsgHead;
import com.msds.dealAgentCollPay.bean.ThirdPayConstant;
import com.msds.dealAgentCollPay.bean.TradeMsgInfo;
import com.msyd.gateway.bean.payChannel.req.AgentPayReq;
import com.msyd.gateway.bean.payChannel.req.PayChannelBaseReq;
import com.msyd.gateway.bean.payChannel.res.AgentPayRes;
import com.msyd.gateway.bean.payChannel.res.PayChannelBaseRes;
import com.msyd.gateway.bean.req.BalanceQueryReq;
import com.msyd.gateway.bean.req.BaseReq;
import com.msyd.gateway.bean.req.IdentityAuthQueryReq;
import com.msyd.gateway.bean.req.IdentityAuthReq;
import com.msyd.gateway.bean.req.MoneyRecordQueryReq;
import com.msyd.gateway.bean.req.PayReq;
import com.msyd.gateway.bean.req.QuickAuthSMSReq;
import com.msyd.gateway.bean.req.QuickPayReq;
import com.msyd.gateway.bean.req.SingleNoticeReq;
import com.msyd.gateway.bean.req.SingleTradeQueryReq;
import com.msyd.gateway.bean.req.TradeDetailQueryReq;
import com.msyd.gateway.bean.req.VerCodeSendReq;
import com.msyd.gateway.bean.req.WithdrawReq;
import com.msyd.gateway.bean.res.BalanceQueryRes;
import com.msyd.gateway.bean.res.BaseRes;
import com.msyd.gateway.bean.res.IdentityAuthQueryRes;
import com.msyd.gateway.bean.res.IdentityAuthRes;
import com.msyd.gateway.bean.res.MoneyRecordQueryRes;
import com.msyd.gateway.bean.res.PayRes;
import com.msyd.gateway.bean.res.QuickAuthSMSRes;
import com.msyd.gateway.bean.res.QuickPayRes;
import com.msyd.gateway.bean.res.SingleNoticeRes;
import com.msyd.gateway.bean.res.SingleTradeQueryRes;
import com.msyd.gateway.bean.res.TradeDetailQueryRes;
import com.msyd.gateway.bean.res.VerCodeSendRes;
import com.msyd.gateway.bean.res.WithdrawRes;
import com.msyd.gateway.converter.PayChannelConverter;
import com.msyd.gateway.dao.model.GatewayPayOrder;
import com.msyd.gateway.enums.AgentPayStateMappingEnum;
import com.msyd.gateway.enums.AgentPayTranCodeMappingEnum;
import com.msyd.gateway.enums.PayChannelEnum;
import com.msyd.gateway.enums.ResCodeEnum;
import com.msyd.gateway.enums.SubTranCodeEnum;
import com.msyd.gateway.enums.TranCodeEnum;
import com.msyd.gateway.service.PayOrderService;
import com.msyd.gateway.utils.DateUtil;
import com.msyd.gateway.utils.NumberGenerator;
import com.msyd.gateway.utils.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="agentPayConverter")
public class AgentPayConverter
implements PayChannelConverter {
    private static final Log log = LogFactory.getLog(AgentPayConverter.class);
    @Resource
    PayOrderService payOrderService;

    @Override
    public PayChannelBaseReq baseToPayChannelReq(BaseReq baseReq) {
        log.debug((Object)"baseToPayChannelReq start");
        AgentPayReq agentPayReq = new AgentPayReq();
        agentPayReq.setB_payChannelEnum(PayChannelEnum.AGENT_PAY);
        agentPayReq.setB_tranCode(baseReq.getB_tranCode());
        agentPayReq.setB_subTranCode(baseReq.getB_subTranCode());
        if (TranCodeEnum.PAY.getCode().equals(agentPayReq.getB_tranCode())) {
            this.payReqConvert(baseReq, agentPayReq);
        } else if (TranCodeEnum.WITHDRAW.getCode().equals(agentPayReq.getB_tranCode())) {
            this.withdrawReqConvert(baseReq, agentPayReq);
        } else if (TranCodeEnum.QUICK_AUTH_SMS.getCode().equals(agentPayReq.getB_tranCode())) {
            this.quickAuthSMSReqConvert(baseReq, agentPayReq);
        } else if (TranCodeEnum.QUICK_PAY.getCode().equals(agentPayReq.getB_tranCode())) {
            this.quickPayReqConvert(baseReq, agentPayReq);
        } else if (TranCodeEnum.VER_CODE_SEND.getCode().equals(agentPayReq.getB_tranCode())) {
            this.verCodeSendReqConvert(baseReq, agentPayReq);
        } else if (TranCodeEnum.IDENTITY_AUTH.getCode().equals(agentPayReq.getB_tranCode())) {
            this.identityAuthReqConvert(baseReq, agentPayReq);
        } else if (TranCodeEnum.SINGLE_TRADE_QUERY.getCode().equals(agentPayReq.getB_tranCode())) {
            this.singleTradeQueryReqConvert(baseReq, agentPayReq);
        } else if (TranCodeEnum.BALANCE_QUERY.getCode().equals(agentPayReq.getB_tranCode())) {
            this.balanceQueryReqConvert(baseReq, agentPayReq);
        } else if (TranCodeEnum.TRADE_DETAIL_QUERY.getCode().equals(agentPayReq.getB_tranCode())) {
            this.tradeDetailQueryReqConvert(baseReq, agentPayReq);
        } else if (TranCodeEnum.MONEY_RECORD_QUERY.getCode().equals(agentPayReq.getB_tranCode())) {
            this.moneyRecordQueryReqConvert(baseReq, agentPayReq);
        } else if (TranCodeEnum.IDENTITY_AUTH_QUERY.getCode().equals(agentPayReq.getB_tranCode())) {
            this.identityAuthQueryReqConvert(baseReq, agentPayReq);
        } else if (TranCodeEnum.SINGLE_NOTICE.getCode().equals(agentPayReq.getB_tranCode())) {
            this.singleNoticeReqConvert(baseReq, agentPayReq);
        } else {
            agentPayReq = null;
        }
        log.debug((Object)"baseToPayChannelReq end");
        return agentPayReq;
    }

    @Override
    public BaseRes payChannelToBaseRes(PayChannelBaseRes payChannelBaseRes) {
        AgentPayRes agentPayRes = (AgentPayRes)payChannelBaseRes;
        if (TranCodeEnum.PAY.getCode().equals(payChannelBaseRes.getB_tranCode())) {
            PayRes payRes = new PayRes();
            this.payResConvert(agentPayRes, payRes);
            return payRes;
        }
        if (TranCodeEnum.WITHDRAW.getCode().equals(payChannelBaseRes.getB_tranCode())) {
            WithdrawRes withdrawRes = new WithdrawRes();
            this.withdrawResConvert(agentPayRes, withdrawRes);
            return withdrawRes;
        }
        if (TranCodeEnum.QUICK_AUTH_SMS.getCode().equals(payChannelBaseRes.getB_tranCode())) {
            QuickAuthSMSRes quickAuthSMSRes = new QuickAuthSMSRes();
            this.quickAuthSMSResConvert(agentPayRes, quickAuthSMSRes);
            return quickAuthSMSRes;
        }
        if (TranCodeEnum.QUICK_PAY.getCode().equals(payChannelBaseRes.getB_tranCode())) {
            QuickPayRes quickPayRes = new QuickPayRes();
            this.quickPayResConvert(agentPayRes, quickPayRes);
            return quickPayRes;
        }
        if (TranCodeEnum.VER_CODE_SEND.getCode().equals(payChannelBaseRes.getB_tranCode())) {
            VerCodeSendRes verCodeSendRes = new VerCodeSendRes();
            this.verCodeSendResConvert(agentPayRes, verCodeSendRes);
            return verCodeSendRes;
        }
        if (TranCodeEnum.IDENTITY_AUTH.getCode().equals(payChannelBaseRes.getB_tranCode())) {
            IdentityAuthRes identityAuthRes = new IdentityAuthRes();
            this.identityAuthResConvert(agentPayRes, identityAuthRes);
            return identityAuthRes;
        }
        if (TranCodeEnum.SINGLE_TRADE_QUERY.getCode().equals(payChannelBaseRes.getB_tranCode())) {
            SingleTradeQueryRes singleTradeQueryRes = new SingleTradeQueryRes();
            this.singleTradeQueryResConvert(agentPayRes, singleTradeQueryRes);
            return singleTradeQueryRes;
        }
        if (TranCodeEnum.BALANCE_QUERY.getCode().equals(payChannelBaseRes.getB_tranCode())) {
            BalanceQueryRes balanceQueryRes = new BalanceQueryRes();
            this.balanceQueryResConvert(agentPayRes, balanceQueryRes);
            return balanceQueryRes;
        }
        if (TranCodeEnum.TRADE_DETAIL_QUERY.getCode().equals(payChannelBaseRes.getB_tranCode())) {
            TradeDetailQueryRes tradeDetailQueryRes = new TradeDetailQueryRes();
            this.tradeDetailQueryResConvert(agentPayRes, tradeDetailQueryRes);
            return tradeDetailQueryRes;
        }
        if (TranCodeEnum.MONEY_RECORD_QUERY.getCode().equals(payChannelBaseRes.getB_tranCode())) {
            MoneyRecordQueryRes moneyRecordQueryRes = new MoneyRecordQueryRes();
            this.moneyRecordQueryResConvert(agentPayRes, moneyRecordQueryRes);
            return moneyRecordQueryRes;
        }
        if (TranCodeEnum.IDENTITY_AUTH_QUERY.getCode().equals(payChannelBaseRes.getB_tranCode())) {
            IdentityAuthQueryRes identityAuthQueryRes = new IdentityAuthQueryRes();
            this.identityAuthQueryResConvert(agentPayRes, identityAuthQueryRes);
            return identityAuthQueryRes;
        }
        if (TranCodeEnum.SINGLE_NOTICE.getCode().equals(payChannelBaseRes.getB_tranCode())) {
            SingleNoticeRes singleNoticeRes = new SingleNoticeRes();
            this.singleNoticeResConvert(agentPayRes, singleNoticeRes);
            return singleNoticeRes;
        }
        return null;
    }

    @Override
    public PayRes payChannelToPayRes(PayChannelBaseRes payChannelBaseRes) {
        AgentPayRes agentPayRes = (AgentPayRes)payChannelBaseRes;
        PayRes payRes = new PayRes();
        this.payResConvert(agentPayRes, payRes);
        return payRes;
    }

    private void payReqConvert(BaseReq baseReq, AgentPayReq agentPayReq) {
        PayReq payReq = (PayReq)baseReq;
        MsgHead head = this.produceMsgHead("CP0001", ThirdPayConstant.MERCHANT_KEY_DAISHOU);
        ArrayList<CP0001or3_MsgBody> bodys = new ArrayList<CP0001or3_MsgBody>();
        CP0001or3_MsgBody body = new CP0001or3_MsgBody();
        body.setMerPlatAcctAlias(payReq.getMerPlatAcctAlias());
        body.setProtocolNo(payReq.getProtocolNo());
        body.setBankName(payReq.getBankName());
        body.setAccountNo(payReq.getAccountNo());
        body.setAccountName(payReq.getAccountName());
        body.setAccountType(payReq.getAccountType());
        body.setOpenProvince(payReq.getOpenProvince());
        body.setOpenCity(payReq.getOpenCity());
        body.setOpenName(payReq.getOpenName());
        body.setTranAmt(payReq.getTradeAmount().toString());
        body.setCurType(payReq.getCurrency());
        body.setBsnType(payReq.getBsnType());
        body.setCertType(payReq.getCertType());
        body.setCertNo(payReq.getCertNo());
        body.setMobileNo(payReq.getMobileNo());
        body.setProdInfo(payReq.getProdInfo());
        body.setMsgExt(payReq.getMsgExt());
        bodys.add(body);
        agentPayReq.setHead(head);
        agentPayReq.setBodys(bodys);
    }

    private void payResConvert(AgentPayRes<?> agentPayRes, PayRes payRes) {
        TradeMsgInfo tradeMsgInfo = (TradeMsgInfo)agentPayRes.getReturnObj();
        ResCodeEnum resCodeEnum = this.resCodeConvert(tradeMsgInfo.getRespcode());
        payRes.setB_resCode(resCodeEnum.getCode());
        payRes.setB_resMsg(tradeMsgInfo.getRespmsg());
        if (ResCodeEnum.SUCCESS.equals((Object)resCodeEnum)) {
            payRes.setB_state(AgentPayStateMappingEnum.getByValue(tradeMsgInfo.getTranState()).getState());
        }
    }

    private void withdrawReqConvert(BaseReq baseReq, AgentPayReq agentPayReq) {
        WithdrawReq withdrawReq = (WithdrawReq)baseReq;
        MsgHead head = this.produceMsgHead("CP0003", ThirdPayConstant.MERCHANT_KEY_DAIFU);
        ArrayList<CP0001or3_MsgBody> bodys = new ArrayList<CP0001or3_MsgBody>();
        CP0001or3_MsgBody body = new CP0001or3_MsgBody();
        body.setMerPlatAcctAlias(withdrawReq.getMerPlatAcctAlias());
        body.setProtocolNo(withdrawReq.getProtocolNo());
        body.setBankName(withdrawReq.getBankName());
        body.setAccountNo(withdrawReq.getAccountNo());
        body.setAccountName(withdrawReq.getAccountName());
        body.setAccountType(withdrawReq.getAccountType());
        body.setOpenProvince(withdrawReq.getOpenProvince());
        body.setOpenCity(withdrawReq.getOpenCity());
        body.setOpenName(withdrawReq.getOpenName());
        body.setTranAmt(withdrawReq.getTradeAmount().toString());
        body.setCurType(withdrawReq.getCurrency());
        body.setBsnType(withdrawReq.getBsnType());
        body.setCertType(withdrawReq.getCertType());
        body.setCertNo(withdrawReq.getCertNo());
        body.setMobileNo(withdrawReq.getMobileNo());
        body.setProdInfo(withdrawReq.getProdInfo());
        body.setMsgExt(withdrawReq.getMsgExt());
        bodys.add(body);
        agentPayReq.setHead(head);
        agentPayReq.setBodys(bodys);
    }

    private void withdrawResConvert(AgentPayRes<?> agentPayRes, WithdrawRes withdrawRes) {
        TradeMsgInfo tradeMsgInfo = (TradeMsgInfo)agentPayRes.getReturnObj();
        ResCodeEnum resCodeEnum = this.resCodeConvert(tradeMsgInfo.getRespcode());
        withdrawRes.setB_resCode(resCodeEnum.getCode());
        withdrawRes.setB_resMsg(tradeMsgInfo.getRespmsg());
        if (ResCodeEnum.SUCCESS.equals((Object)resCodeEnum)) {
            withdrawRes.setB_state(AgentPayStateMappingEnum.getByValue(tradeMsgInfo.getTranState()).getState());
        }
    }

    private void quickAuthSMSReqConvert(BaseReq baseReq, AgentPayReq agentPayReq) {
        QuickAuthSMSReq quickAuthSMSReq = (QuickAuthSMSReq)baseReq;
        MsgHead head = this.produceMsgHead("CP0028", ThirdPayConstant.MERCHANT_KEY_DAISHOU);
        ArrayList<CP0028_MsgBody> bodys = new ArrayList<CP0028_MsgBody>();
        CP0028_MsgBody body = new CP0028_MsgBody();
        body.setBankName(quickAuthSMSReq.getBankName());
        body.setAccountNo(quickAuthSMSReq.getAccountNo());
        body.setAccountName(quickAuthSMSReq.getAccountName());
        body.setTranAmt(quickAuthSMSReq.getTradeAmount().toString());
        body.setCertType(quickAuthSMSReq.getCertType());
        body.setCertNo(quickAuthSMSReq.getCertNo());
        body.setMobileNo(quickAuthSMSReq.getMobileNo());
        body.setExpiredDate(quickAuthSMSReq.getExpiredDate());
        body.setCvv2(quickAuthSMSReq.getCvv2());
        bodys.add(body);
        agentPayReq.setHead(head);
        agentPayReq.setBodys(bodys);
    }

    private void quickAuthSMSResConvert(AgentPayRes<?> agentPayRes, QuickAuthSMSRes quickAuthSMSRes) {
        CP0028_MsgInfo msgInfo = (CP0028_MsgInfo)agentPayRes.getReturnObj();
        ResCodeEnum resCodeEnum = this.resCodeConvert(msgInfo.getRespcode());
        quickAuthSMSRes.setMerOrderId(msgInfo.getMerOrderId());
        quickAuthSMSRes.setCustId(msgInfo.getCustId());
        quickAuthSMSRes.setPhoneToken(msgInfo.getPhoneToken());
        quickAuthSMSRes.setB_resCode(resCodeEnum.getCode());
        quickAuthSMSRes.setB_resMsg(msgInfo.getRespmsg());
    }

    private void quickPayReqConvert(BaseReq baseReq, AgentPayReq agentPayReq) {
        QuickPayReq quickPayReq = (QuickPayReq)baseReq;
        MsgHead head = this.produceMsgHead("CP0029", ThirdPayConstant.MERCHANT_KEY_DAISHOU);
        ArrayList<CP0029_MsgBody> bodys = new ArrayList<CP0029_MsgBody>();
        CP0029_MsgBody body = new CP0029_MsgBody();
        body.setBankName(quickPayReq.getBankName());
        body.setAccountNo(quickPayReq.getAccountNo());
        body.setAccountName(quickPayReq.getAccountName());
        body.setTranAmt(quickPayReq.getTradeAmount().toString());
        body.setCertType(quickPayReq.getCertType());
        body.setCertNo(quickPayReq.getCertNo());
        body.setMobileNo(quickPayReq.getMobileNo());
        body.setExpiredDate(quickPayReq.getExpiredDate());
        body.setCvv2(quickPayReq.getCvv2());
        body.setMerOrderId(quickPayReq.getMerOrderId());
        body.setCustId(quickPayReq.getCustId());
        body.setPhoneToken(quickPayReq.getPhoneToken());
        body.setPhoneVerCode(quickPayReq.getPhoneVerCode());
        bodys.add(body);
        agentPayReq.setHead(head);
        agentPayReq.setBodys(bodys);
    }

    private void quickPayResConvert(AgentPayRes<?> agentPayRes, QuickPayRes quickPayRes) {
        TradeMsgInfo tradeMsgInfo = (TradeMsgInfo)agentPayRes.getReturnObj();
        ResCodeEnum resCodeEnum = this.resCodeConvert(tradeMsgInfo.getRespcode());
        quickPayRes.setB_resCode(resCodeEnum.getCode());
        quickPayRes.setB_resMsg(tradeMsgInfo.getRespmsg());
        if (ResCodeEnum.SUCCESS.equals((Object)resCodeEnum)) {
            quickPayRes.setB_state(AgentPayStateMappingEnum.getByValue(tradeMsgInfo.getTranState()).getState());
        }
    }

    private void verCodeSendReqConvert(BaseReq baseReq, AgentPayReq agentPayReq) {
        VerCodeSendReq verCodeSendReq = (VerCodeSendReq)baseReq;
        MsgHead head = this.produceMsgHead("CP0032", ThirdPayConstant.MERCHANT_KEY_DAISHOU);
        ArrayList<CP0032_MsgBody> bodys = new ArrayList<CP0032_MsgBody>();
        CP0032_MsgBody body = new CP0032_MsgBody();
        body.setAccountName(verCodeSendReq.getAccountName());
        body.setMobileNo(verCodeSendReq.getMobileNo());
        bodys.add(body);
        agentPayReq.setHead(head);
        agentPayReq.setBodys(bodys);
    }

    private void verCodeSendResConvert(AgentPayRes<?> agentPayRes, VerCodeSendRes verCodeSendRes) {
        CP0032_MsgInfo msgInfo = (CP0032_MsgInfo)agentPayRes.getReturnObj();
        ResCodeEnum resCodeEnum = this.resCodeConvert(msgInfo.getRespcode());
        verCodeSendRes.setB_resCode(resCodeEnum.getCode());
        verCodeSendRes.setB_resMsg(msgInfo.getRespmsg());
        verCodeSendRes.setPhoneToken(msgInfo.getPhoneToken());
        verCodeSendRes.setPhoneVerCode(msgInfo.getPhoneVerCode());
    }

    private void identityAuthReqConvert(BaseReq baseReq, AgentPayReq agentPayReq) {
        IdentityAuthReq identityAuthReq = (IdentityAuthReq)baseReq;
        MsgHead head = this.produceMsgHead("CP0030", ThirdPayConstant.MERCHANT_KEY_DAISHOU);
        ArrayList<CP0030_MsgBody> bodys = new ArrayList<CP0030_MsgBody>();
        CP0030_MsgBody body = new CP0030_MsgBody();
        body.setBankName(identityAuthReq.getBankName());
        body.setAccountNo(identityAuthReq.getAccountNo());
        body.setAccountName(identityAuthReq.getAccountName());
        body.setAccountType(identityAuthReq.getAccountType());
        body.setCertType(identityAuthReq.getCertType());
        body.setCertNo(identityAuthReq.getCertNo());
        body.setMobileNo(identityAuthReq.getMobileNo());
        body.setPhoneToken(identityAuthReq.getPhoneToken());
        body.setPhoneVerCode(identityAuthReq.getPhoneVerCode());
        bodys.add(body);
        agentPayReq.setHead(head);
        agentPayReq.setBodys(bodys);
    }

    private void identityAuthResConvert(AgentPayRes<?> agentPayRes, IdentityAuthRes identityAuthRes) {
        TradeMsgInfo tradeMsgInfo = (TradeMsgInfo)agentPayRes.getReturnObj();
        ResCodeEnum resCodeEnum = this.resCodeConvert(tradeMsgInfo.getRespcode());
        identityAuthRes.setB_resCode(resCodeEnum.getCode());
        identityAuthRes.setB_resMsg(tradeMsgInfo.getRespmsg());
        if (ResCodeEnum.SUCCESS.equals((Object)resCodeEnum)) {
            identityAuthRes.setB_state(AgentPayStateMappingEnum.getByValue(tradeMsgInfo.getTranState()).getState());
        }
    }

    private void singleTradeQueryReqConvert(BaseReq baseReq, AgentPayReq agentPayReq) {
        SingleTradeQueryReq singleTradeQueryReq = (SingleTradeQueryReq)baseReq;
        MsgHead head = null;
        ArrayList<CP0002or4_MsgBody> bodys = new ArrayList<CP0002or4_MsgBody>();
        CP0002or4_MsgBody body = new CP0002or4_MsgBody();
        List<GatewayPayOrder> lst = this.payOrderService.queryByMerOrderId(singleTradeQueryReq.getOrgMerOrderId());
        if (lst != null) {
            body.setOrgTranFlow(lst.get(0).getPayChannelOrderId());
        }
        bodys.add(body);
        if (TranCodeEnum.PAY.getCode().equals(lst.get(0).getTranCode())) {
            head = this.produceMsgHead("CP0002", ThirdPayConstant.MERCHANT_KEY_DAISHOU);
        } else if (TranCodeEnum.WITHDRAW.getCode().equals(lst.get(0).getTranCode())) {
            head = this.produceMsgHead("CP0004", ThirdPayConstant.MERCHANT_KEY_DAIFU);
        }
        agentPayReq.setHead(head);
        agentPayReq.setBodys(bodys);
    }

    private void singleTradeQueryResConvert(AgentPayRes<?> agentPayRes, SingleTradeQueryRes singleTradeQueryRes) {
        CP0002or4_MsgInfo msgInfo = (CP0002or4_MsgInfo)agentPayRes.getReturnObj();
        ResCodeEnum resCodeEnum = this.resCodeConvert(msgInfo.getRespcode());
        singleTradeQueryRes.setB_resCode(resCodeEnum.getCode());
        singleTradeQueryRes.setB_resMsg(msgInfo.getRespmsg());
        ResCodeEnum resCodeEnumTran = this.resCodeConvert(msgInfo.getTranRespCode());
        singleTradeQueryRes.setTranResCode(resCodeEnumTran.getCode());
        singleTradeQueryRes.setTranResMsg(msgInfo.getTranRespMsg());
        singleTradeQueryRes.setTranState(AgentPayStateMappingEnum.getByValue(msgInfo.getTranState()).getState());
    }

    private void balanceQueryReqConvert(BaseReq baseReq, AgentPayReq agentPayReq) {
        BalanceQueryReq balanceQueryReq = (BalanceQueryReq)baseReq;
        if (SubTranCodeEnum.SUB_01.getCode().equals(balanceQueryReq.getB_subTranCode())) {
            MsgHead head = this.produceMsgHead("CP0020", ThirdPayConstant.MERCHANT_KEY_QUERY);
            ArrayList<CP0020_MsgBody> bodys = new ArrayList<CP0020_MsgBody>();
            CP0020_MsgBody body = new CP0020_MsgBody();
            body.setAcctNo(balanceQueryReq.getAcctNo());
            bodys.add(body);
            agentPayReq.setHead(head);
            agentPayReq.setBodys(bodys);
        } else {
            MsgHead head = this.produceMsgHead("CP0021", ThirdPayConstant.MERCHANT_KEY_QUERY);
            ArrayList<CP0021_MsgBody> bodys = new ArrayList<CP0021_MsgBody>();
            CP0021_MsgBody body = new CP0021_MsgBody();
            body.setAcctNo(balanceQueryReq.getAcctNo());
            body.setQueryTime(balanceQueryReq.getQueryTime());
            bodys.add(body);
            agentPayReq.setHead(head);
            agentPayReq.setBodys(bodys);
        }
    }

    private void balanceQueryResConvert(AgentPayRes<?> agentPayRes, BalanceQueryRes balanceQueryRes) {
        CP0020or21_MsgInfo msgInfo = (CP0020or21_MsgInfo)agentPayRes.getReturnObj();
        ResCodeEnum resCodeEnum = this.resCodeConvert(msgInfo.getRespcode());
        balanceQueryRes.setB_resCode(resCodeEnum.getCode());
        balanceQueryRes.setB_resMsg(msgInfo.getRespmsg());
        balanceQueryRes.setQueryTime(msgInfo.getQueryTime());
        balanceQueryRes.setAcctNo(msgInfo.getAcctNo());
        if (!StringUtil.isEmpty(msgInfo.getBalance())) {
            balanceQueryRes.setBalance(new BigDecimal(msgInfo.getBalance()));
        }
    }

    private void tradeDetailQueryReqConvert(BaseReq baseReq, AgentPayReq agentPayReq) {
        TradeDetailQueryReq tradeDetailQueryReq = (TradeDetailQueryReq)baseReq;
        if (SubTranCodeEnum.SUB_01.getCode().equals(tradeDetailQueryReq.getB_subTranCode())) {
            MsgHead head = this.produceMsgHead("CP0022", ThirdPayConstant.MERCHANT_KEY_QUERY);
            ArrayList<CP0022_MsgBody> bodys = new ArrayList<CP0022_MsgBody>();
            CP0022_MsgBody body = new CP0022_MsgBody();
            if ("0".equals(tradeDetailQueryReq.getTranCode())) {
                body.setTranCode("All");
            } else {
                body.setTranCode(AgentPayTranCodeMappingEnum.getByCode(tradeDetailQueryReq.getTranCode() + tradeDetailQueryReq.getB_subTranCode()).getAgentPayTranCode());
            }
            if ("0".equals(tradeDetailQueryReq.getTranState())) {
                body.setTranState("99");
            } else {
                body.setTranState(AgentPayStateMappingEnum.getByCode(tradeDetailQueryReq.getTranState()).getAgentPayState());
            }
            body.setStartTime(tradeDetailQueryReq.getStartTime());
            body.setEndTime(tradeDetailQueryReq.getEndTime());
            bodys.add(body);
            agentPayReq.setHead(head);
            agentPayReq.setBodys(bodys);
        } else {
            MsgHead head = this.produceMsgHead("CP0023", ThirdPayConstant.MERCHANT_KEY_QUERY);
            ArrayList<CP0023_MsgBody> bodys = new ArrayList<CP0023_MsgBody>();
            CP0023_MsgBody body = new CP0023_MsgBody();
            if ("0".equals(tradeDetailQueryReq.getTranCode())) {
                body.setTranCode("All");
            } else {
                body.setTranCode(AgentPayTranCodeMappingEnum.getByCode(tradeDetailQueryReq.getTranCode() + tradeDetailQueryReq.getB_subTranCode()).getAgentPayTranCode());
            }
            if ("0".equals(tradeDetailQueryReq.getTranState())) {
                body.setTranState("99");
            } else {
                body.setTranState(AgentPayStateMappingEnum.getByCode(tradeDetailQueryReq.getTranState()).getAgentPayState());
            }
            body.setStartDate(tradeDetailQueryReq.getStartTime());
            body.setEndDate(tradeDetailQueryReq.getEndTime());
            bodys.add(body);
            agentPayReq.setHead(head);
            agentPayReq.setBodys(bodys);
        }
    }

    private void tradeDetailQueryResConvert(AgentPayRes<?> agentPayRes, TradeDetailQueryRes tradeDetailQueryRes) {
        CP0022To25_MsgInfo msgInfo = (CP0022To25_MsgInfo)agentPayRes.getReturnObj();
        ResCodeEnum resCodeEnum = this.resCodeConvert(msgInfo.getRespcode());
        tradeDetailQueryRes.setB_resCode(resCodeEnum.getCode());
        tradeDetailQueryRes.setB_resMsg(msgInfo.getRespmsg());
        if (StringUtil.isEmpty(msgInfo.getTotalNum())) {
            tradeDetailQueryRes.setTotalNum(0);
        } else {
            tradeDetailQueryRes.setTotalNum(Integer.valueOf(msgInfo.getTotalNum()));
        }
        tradeDetailQueryRes.setHashCode(msgInfo.getHashCode());
        tradeDetailQueryRes.setData(msgInfo.getData());
    }

    private void moneyRecordQueryReqConvert(BaseReq baseReq, AgentPayReq agentPayReq) {
        MoneyRecordQueryReq moneyRecordQueryReq = (MoneyRecordQueryReq)baseReq;
        if (SubTranCodeEnum.SUB_01.getCode().equals(moneyRecordQueryReq.getB_subTranCode())) {
            MsgHead head = this.produceMsgHead("CP0024", ThirdPayConstant.MERCHANT_KEY_QUERY);
            ArrayList<CP0024_MsgBody> bodys = new ArrayList<CP0024_MsgBody>();
            CP0024_MsgBody body = new CP0024_MsgBody();
            body.setAcctNo(moneyRecordQueryReq.getAcctNo());
            body.setStartTime(moneyRecordQueryReq.getStartTime());
            body.setEndTime(moneyRecordQueryReq.getEndTime());
            bodys.add(body);
            agentPayReq.setHead(head);
            agentPayReq.setBodys(bodys);
        } else {
            MsgHead head = this.produceMsgHead("CP0025", ThirdPayConstant.MERCHANT_KEY_QUERY);
            ArrayList<CP0025_MsgBody> bodys = new ArrayList<CP0025_MsgBody>();
            CP0025_MsgBody body = new CP0025_MsgBody();
            body.setAcctNo(moneyRecordQueryReq.getAcctNo());
            body.setStartDate(moneyRecordQueryReq.getStartTime());
            body.setEndDate(moneyRecordQueryReq.getEndTime());
            bodys.add(body);
            agentPayReq.setHead(head);
            agentPayReq.setBodys(bodys);
        }
    }

    private void moneyRecordQueryResConvert(AgentPayRes<?> agentPayRes, MoneyRecordQueryRes moneyRecordQueryRes) {
        CP0022To25_MsgInfo msgInfo = (CP0022To25_MsgInfo)agentPayRes.getReturnObj();
        ResCodeEnum resCodeEnum = this.resCodeConvert(msgInfo.getRespcode());
        moneyRecordQueryRes.setB_resCode(resCodeEnum.getCode());
        moneyRecordQueryRes.setB_resMsg(msgInfo.getRespmsg());
        if (StringUtil.isEmpty(msgInfo.getTotalNum())) {
            moneyRecordQueryRes.setTotalNum(0);
        } else {
            moneyRecordQueryRes.setTotalNum(Integer.valueOf(msgInfo.getTotalNum()));
        }
        moneyRecordQueryRes.setHashCode(msgInfo.getHashCode());
        moneyRecordQueryRes.setData(msgInfo.getData());
    }

    private void identityAuthQueryReqConvert(BaseReq baseReq, AgentPayReq agentPayReq) {
        IdentityAuthQueryReq identityAuthQueryReq = (IdentityAuthQueryReq)baseReq;
        MsgHead head = this.produceMsgHead("CP0031", ThirdPayConstant.MERCHANT_KEY_QUERY);
        ArrayList<CP0031_MsgBody> bodys = new ArrayList<CP0031_MsgBody>();
        CP0031_MsgBody body = new CP0031_MsgBody();
        body.setAccountNo(identityAuthQueryReq.getAccountNo());
        body.setAccountName(identityAuthQueryReq.getAccountName());
        body.setCertNo(identityAuthQueryReq.getCertNo());
        body.setMobileNo(identityAuthQueryReq.getMobileNo());
        bodys.add(body);
        agentPayReq.setHead(head);
        agentPayReq.setBodys(bodys);
    }

    private void identityAuthQueryResConvert(AgentPayRes<?> agentPayRes, IdentityAuthQueryRes identityAuthQueryRes) {
        TradeMsgInfo tradeMsgInfo = (TradeMsgInfo)agentPayRes.getReturnObj();
        ResCodeEnum resCodeEnum = this.resCodeConvert(tradeMsgInfo.getRespcode());
        identityAuthQueryRes.setB_resCode(resCodeEnum.getCode());
        identityAuthQueryRes.setB_resMsg(tradeMsgInfo.getRespmsg());
        if (ResCodeEnum.SUCCESS.equals((Object)resCodeEnum)) {
            identityAuthQueryRes.setTranState(AgentPayStateMappingEnum.getByValue(tradeMsgInfo.getTranState()).getState());
        }
    }

    private void singleNoticeReqConvert(BaseReq baseReq, AgentPayReq agentPayReq) {
        SingleNoticeReq singleNoticeReq = (SingleNoticeReq)baseReq;
        MsgHead head = this.produceMsgHead("CP0006", ThirdPayConstant.MERCHANT_KEY_DAIFU);
        ArrayList<CP0006_MsgBody> bodys = new ArrayList<CP0006_MsgBody>();
        CP0006_MsgBody body = new CP0006_MsgBody();
        body.setXml(singleNoticeReq.getMsg());
        body.setMac(singleNoticeReq.getMac());
        bodys.add(body);
        agentPayReq.setHead(head);
        agentPayReq.setBodys(bodys);
    }

    private void singleNoticeResConvert(AgentPayRes<?> agentPayRes, SingleNoticeRes singleNoticeRes) {
        CP0006_MsgInfo msgInfo = (CP0006_MsgInfo)agentPayRes.getReturnObj();
        ResCodeEnum resCodeEnum = this.resCodeConvert(msgInfo.getRespcode());
        singleNoticeRes.setB_resCode(resCodeEnum.getCode());
        singleNoticeRes.setB_resMsg(msgInfo.getRespmsg());
        List<GatewayPayOrder> lst = this.payOrderService.queryByPayChannelOrderId(msgInfo.getOrgTranFlow());
        if (lst == null || lst.size() != 1) {
            singleNoticeRes.setB_resCode(ResCodeEnum.WARNING.getCode());
            singleNoticeRes.setB_resMsg(ResCodeEnum.WARNING.getMsg());
            return;
        }
        singleNoticeRes.setB_orderId(lst.get(0).getMerOrderId());
        singleNoticeRes.setOrgMerOrderId(lst.get(0).getMerOrderId());
        singleNoticeRes.setAccountNo(msgInfo.getAccountNo());
        singleNoticeRes.setAccountName(msgInfo.getAccountName());
        if (!StringUtil.isEmpty(msgInfo.getTranAmt())) {
            singleNoticeRes.setTradeAmount(new BigDecimal(msgInfo.getTranAmt()));
        }
        singleNoticeRes.setTranResCode(resCodeEnum.getCode());
        singleNoticeRes.setTranResMsg(msgInfo.getRespmsg());
        if (ResCodeEnum.SUCCESS.equals((Object)resCodeEnum)) {
            singleNoticeRes.setTranState(AgentPayStateMappingEnum.getByValue(msgInfo.getTranState()).getState());
        }
    }

    public ResCodeEnum resCodeConvert(String AgentPayResCode) {
        if ("C000000000".equals(AgentPayResCode)) {
            return ResCodeEnum.SUCCESS;
        }
        if (AgentPayResCode.startsWith("W")) {
            return ResCodeEnum.WARNING;
        }
        return ResCodeEnum.ERROR;
    }

    private MsgHead produceMsgHead(String tranCode, String merchanKey) {
        MsgHead head = new MsgHead();
        String sNow = DateUtil.getNowDateString("yyyyMMddHHmmss");
        head.setVersion(ThirdPayConstant.VERSION);
        head.setMerchantno(ThirdPayConstant.MERCHANT_NO);
        head.setBussflowno(ThirdPayConstant.MERCHANT_NO + sNow + NumberGenerator.generateByLength(6));
        head.setMsgtype(ThirdPayConstant.MSGTYPE_REQ);
        head.setTrancode(tranCode);
        head.setChannelno(ThirdPayConstant.CHANNEL_NO);
        head.setTrandate(sNow.substring(0, 8));
        head.setTrantime(sNow.substring(8));
        head.setMerchanKey(merchanKey);
        return head;
    }
}

