/*
 * Decompiled with CFR 0.152.
 */
package com.msyd.gateway.enums;

import com.msyd.gateway.bean.req.BalanceQueryReq;
import com.msyd.gateway.bean.req.IdentityAuthQueryReq;
import com.msyd.gateway.bean.req.IdentityAuthReq;
import com.msyd.gateway.bean.req.MoneyRecordQueryReq;
import com.msyd.gateway.bean.req.PayReq;
import com.msyd.gateway.bean.req.QuickAuthSMSReq;
import com.msyd.gateway.bean.req.QuickPayReq;
import com.msyd.gateway.bean.req.SingleTradeQueryReq;
import com.msyd.gateway.bean.req.TradeDetailQueryReq;
import com.msyd.gateway.bean.req.VerCodeSendReq;
import com.msyd.gateway.bean.req.WithdrawReq;
import com.msyd.gateway.bean.res.BalanceQueryRes;
import com.msyd.gateway.bean.res.IdentityAuthQueryRes;
import com.msyd.gateway.bean.res.IdentityAuthRes;
import com.msyd.gateway.bean.res.MoneyRecordQueryRes;
import com.msyd.gateway.bean.res.PayRes;
import com.msyd.gateway.bean.res.QuickAuthSMSRes;
import com.msyd.gateway.bean.res.QuickPayRes;
import com.msyd.gateway.bean.res.SingleNoticeRes;
import com.msyd.gateway.bean.res.SingleTradeQueryRes;
import com.msyd.gateway.bean.res.TradeDetailQueryRes;
import com.msyd.gateway.bean.res.VerCodeSendRes;
import com.msyd.gateway.bean.res.WithdrawRes;
import com.msyd.gateway.enums.TranCodeEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TradeApiEnum {
    PAY(TranCodeEnum.PAY.getCode(), "\u652f\u4ed8", PayReq.class, PayRes.class),
    WITHDRAW(TranCodeEnum.WITHDRAW.getCode(), "\u63d0\u73b0", WithdrawReq.class, WithdrawRes.class),
    QUICK_AUTH_SMS(TranCodeEnum.QUICK_AUTH_SMS.getCode(), "\u5feb\u6377\u9274\u6743\u77ed\u4fe1", QuickAuthSMSReq.class, QuickAuthSMSRes.class),
    QUICK_PAY(TranCodeEnum.QUICK_PAY.getCode(), "\u5feb\u6377\u5145\u503c", QuickPayReq.class, QuickPayRes.class),
    VER_CODE_SEND(TranCodeEnum.VER_CODE_SEND.getCode(), "\u9a8c\u8bc1\u7801", VerCodeSendReq.class, VerCodeSendRes.class),
    IDENTITY_AUTH(TranCodeEnum.IDENTITY_AUTH.getCode(), "\u5b9e\u540d\u8eab\u4efd\u8ba4\u8bc1", IdentityAuthReq.class, IdentityAuthRes.class),
    SINGLE_TRADE_QUERY(TranCodeEnum.SINGLE_TRADE_QUERY.getCode(), "\u5355\u7b14\u4ea4\u6613\u7ed3\u679c\u67e5\u8be2", SingleTradeQueryReq.class, SingleTradeQueryRes.class),
    BALANCE_QUERY(TranCodeEnum.BALANCE_QUERY.getCode(), "\u4f59\u989d\u67e5\u8be2", BalanceQueryReq.class, BalanceQueryRes.class),
    TRADE_DETAIL_QUERY(TranCodeEnum.TRADE_DETAIL_QUERY.getCode(), "\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", TradeDetailQueryReq.class, TradeDetailQueryRes.class),
    MONEY_RECORD_QUERY(TranCodeEnum.MONEY_RECORD_QUERY.getCode(), "\u8d44\u91d1\u6d41\u6c34\u67e5\u8be2", MoneyRecordQueryReq.class, MoneyRecordQueryRes.class),
    IDENTITY_AUTH_QUERY(TranCodeEnum.IDENTITY_AUTH_QUERY.getCode(), "\u5b9e\u540d\u8eab\u4efd\u8ba4\u8bc1\u67e5\u8be2", IdentityAuthQueryReq.class, IdentityAuthQueryRes.class),
    SINGLE_NOTICE(TranCodeEnum.SINGLE_NOTICE.getCode(), "\u5355\u7b14\u4ea4\u6613\u7ed3\u679c\u901a\u77e5", SingleNoticeRes.class, SingleNoticeRes.class);

    private String code;
    private String name;
    private Class<?> reqClass;
    private Class<?> resClass;

    private TradeApiEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    private TradeApiEnum(String code, String name, Class<?> reqClass, Class<?> resClass) {
        this.code = code;
        this.name = name;
        this.reqClass = reqClass;
        this.resClass = resClass;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getReqClass() {
        return this.reqClass;
    }

    public Class<?> getResClass() {
        return this.resClass;
    }

    public static TradeApiEnum getByCode(String code) {
        if (code == null) {
            return null;
        }
        for (TradeApiEnum tradeApiEnum : TradeApiEnum.values()) {
            if (!tradeApiEnum.getCode().equals(code)) continue;
            return tradeApiEnum;
        }
        return null;
    }

    public static TradeApiEnum getByReqClass(Class<?> reqClass) {
        if (reqClass == null) {
            return null;
        }
        for (TradeApiEnum tradeApiEnum : TradeApiEnum.values()) {
            if (!tradeApiEnum.getReqClass().equals(reqClass)) continue;
            return tradeApiEnum;
        }
        return null;
    }

    public static boolean hasCode(String code) {
        if (TradeApiEnum.getByCode(code) == null) {
            return false;
        }
        return false;
    }
}

