/*
 * Decompiled with CFR 0.152.
 */
package com.msyd.gateway.message;

import com.msyd.gateway.enums.ResCodeEnum;
import com.msyd.gateway.utils.MessageHelper;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultData<T>
implements Serializable {
    private static final long serialVersionUID = 5996633696006840414L;
    private String code = ResCodeEnum.SUCCESS.getCode();
    private String msg = ResCodeEnum.SUCCESS.getMsg();
    private T data;

    public ResultData() {
    }

    public ResultData(String code) {
        this.code = code;
        this.msg = MessageHelper.getInstance().getMessageByCode(this.code);
    }

    public ResultData(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
        this.msg = MessageHelper.getInstance().getMessageByCode(this.code);
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean isSuccessful() {
        return ResCodeEnum.SUCCESS.getCode().equals(this.code);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResultData [code=");
        builder.append(this.code);
        builder.append(", msg=");
        builder.append(this.msg);
        builder.append(", data=");
        builder.append(this.data);
        builder.append("]");
        return builder.toString();
    }
}

