/*
 * Decompiled with CFR 0.152.
 */
package com.msyd.gateway.service.impl;

import com.msyd.gateway.bean.payChannel.req.PayChannelBaseReq;
import com.msyd.gateway.bean.payChannel.res.PayChannelBaseRes;
import com.msyd.gateway.bean.req.BalanceQueryReq;
import com.msyd.gateway.bean.req.IdentityAuthQueryReq;
import com.msyd.gateway.bean.req.IdentityAuthReq;
import com.msyd.gateway.bean.req.MoneyRecordQueryReq;
import com.msyd.gateway.bean.req.PayReq;
import com.msyd.gateway.bean.req.QuickAuthSMSReq;
import com.msyd.gateway.bean.req.QuickPayReq;
import com.msyd.gateway.bean.req.SingleNoticeReq;
import com.msyd.gateway.bean.req.SingleTradeQueryReq;
import com.msyd.gateway.bean.req.TradeDetailQueryReq;
import com.msyd.gateway.bean.req.VerCodeSendReq;
import com.msyd.gateway.bean.req.WithdrawReq;
import com.msyd.gateway.bean.res.BalanceQueryRes;
import com.msyd.gateway.bean.res.BaseRes;
import com.msyd.gateway.bean.res.IdentityAuthQueryRes;
import com.msyd.gateway.bean.res.IdentityAuthRes;
import com.msyd.gateway.bean.res.MoneyRecordQueryRes;
import com.msyd.gateway.bean.res.PayRes;
import com.msyd.gateway.bean.res.QuickAuthSMSRes;
import com.msyd.gateway.bean.res.QuickPayRes;
import com.msyd.gateway.bean.res.SingleNoticeRes;
import com.msyd.gateway.bean.res.SingleTradeQueryRes;
import com.msyd.gateway.bean.res.TradeDetailQueryRes;
import com.msyd.gateway.bean.res.VerCodeSendRes;
import com.msyd.gateway.bean.res.WithdrawRes;
import com.msyd.gateway.bean.router.BaseRouterCondition;
import com.msyd.gateway.dao.model.GatewayExpInfo;
import com.msyd.gateway.dao.model.GatewayPayOrder;
import com.msyd.gateway.enums.PayChannelEnum;
import com.msyd.gateway.enums.ResCodeEnum;
import com.msyd.gateway.enums.ResStateEnum;
import com.msyd.gateway.message.ResultData;
import com.msyd.gateway.service.ExpInfoService;
import com.msyd.gateway.service.GatewayService;
import com.msyd.gateway.service.InputCheckService;
import com.msyd.gateway.service.PayChannelService;
import com.msyd.gateway.service.PayOrderService;
import com.msyd.gateway.service.impl.BaseService;
import com.msyd.gateway.utils.DateUtil;
import com.msyd.gateway.utils.TradeBeanUtil;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service(value="gatewayService")
public class GatewayServiceImpl
extends BaseService
implements GatewayService {
    private static final Log log = LogFactory.getLog(GatewayServiceImpl.class);
    @Resource
    PayChannelService payChannelService;
    @Resource
    PayOrderService payOrderService;
    @Resource
    ExpInfoService expInfoService;
    @Resource
    InputCheckService inputCheckService;

    public PayRes pay(PayReq payReq) {
        log.info((Object)"pay start.");
        log.info((Object)("payReq=" + payReq.toString()));
        try {
            ResultData<String> rdCheck = this.inputCheckService.payCheck(payReq);
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdCheck.getCode())) {
                PayRes payRes = (PayRes)TradeBeanUtil.produceResErr(payReq, rdCheck);
                log.info((Object)("\u8f93\u5165\u6821\u9a8c\u9519\u8bef\u3002payRes=" + payRes.toString()));
                return payRes;
            }
            String sNowStart = DateUtil.getNowDateString("yyyyMMddHHmmss");
            payReq.setB_serverDate(sNowStart.substring(0, 8));
            payReq.setB_serverTime(sNowStart.substring(8));
            log.info((Object)"process produceBaseRouterCondition.");
            ResultData<BaseRouterCondition> rdRouterCondition = this.payChannelService.produceBaseRouterCondition(payReq);
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdRouterCondition.getCode())) {
                return (PayRes)TradeBeanUtil.produceResErr(payReq, rdRouterCondition);
            }
            log.info((Object)"process queryPayChannel.");
            ResultData<PayChannelEnum> rdPayChannelEnum = this.payChannelService.queryPayChannel(rdRouterCondition.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelEnum.getCode())) {
                return (PayRes)TradeBeanUtil.produceResErr(payReq, rdPayChannelEnum);
            }
            log.info((Object)"process produceChannelReqBean.");
            ResultData<PayChannelBaseReq> rdPayChannelBaseReq = this.payChannelService.produceChannelReqBean(payReq, rdPayChannelEnum.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseReq.getCode())) {
                return (PayRes)TradeBeanUtil.produceResErr(payReq, rdPayChannelBaseReq);
            }
            GatewayPayOrder gatewayPayOrder = this.payOrderService.produceAddPayOrder(payReq, rdPayChannelEnum.getData(), rdPayChannelBaseReq.getData());
            int count = this.payOrderService.addPayOrder(gatewayPayOrder);
            if (count != 1) {
                ResultData rd = new ResultData();
                rd.setCode("E0000001");
                return (PayRes)TradeBeanUtil.produceResErr(payReq, rd);
            }
            log.info((Object)"process pay.");
            ResultData<PayChannelBaseRes> rdPayChannelBaseRes = this.payChannelService.pay(rdPayChannelBaseReq.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseRes.getCode())) {
                return (PayRes)TradeBeanUtil.produceResErr(payReq, rdPayChannelBaseRes);
            }
            log.info((Object)"process payChannelToPayRes.");
            ResultData<BaseRes> rdPayRes = this.payChannelService.payChannelToBaseRes(rdPayChannelBaseRes.getData(), gatewayPayOrder.getPayOrderId(), gatewayPayOrder.getPayChannelOrderId());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayRes.getCode())) {
                return (PayRes)TradeBeanUtil.produceResErr(payReq, rdPayRes);
            }
            TradeBeanUtil.setRetComm(payReq, rdPayRes.getData());
            GatewayPayOrder gatewayPayOrderUpd = this.payOrderService.produceUpdatePayOrder(gatewayPayOrder.getPayOrderId(), rdPayChannelBaseRes.getData(), rdPayRes.getData());
            if (gatewayPayOrderUpd == null) {
                ResultData rd = new ResultData();
                rd.setCode("W0000003");
                return (PayRes)TradeBeanUtil.produceResErr(payReq, rd);
            }
            count = this.payOrderService.updatePayOrder(gatewayPayOrderUpd);
            if (count != 1) {
                ResultData rd = new ResultData();
                rd.setCode("W0000002");
                return (PayRes)TradeBeanUtil.produceResErr(payReq, rd);
            }
            log.info((Object)("payRes=" + ((PayRes)rdPayRes.getData()).toString()));
            log.info((Object)"pay end.");
            return (PayRes)rdPayRes.getData();
        }
        catch (Exception e) {
            log.error((Object)"\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            this.addExpInfo(payReq.getB_merOrderId(), "", ResCodeEnum.ERROR.getCode(), e.toString());
            PayRes payRes = (PayRes)TradeBeanUtil.produceResCommWarn(payReq);
            log.error((Object)("payRes=" + payRes.toString()));
            return payRes;
        }
    }

    public WithdrawRes withdraw(WithdrawReq withdrawReq) {
        log.info((Object)"withdraw start.");
        log.info((Object)("withdrawReq=" + withdrawReq.toString()));
        try {
            ResultData<String> rdCheck = this.inputCheckService.withdrawCheck(withdrawReq);
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdCheck.getCode())) {
                WithdrawRes withdrawRes = (WithdrawRes)TradeBeanUtil.produceResErr(withdrawReq, rdCheck);
                log.info((Object)("\u8f93\u5165\u6821\u9a8c\u9519\u8bef\u3002withdrawRes=" + withdrawRes.toString()));
                return withdrawRes;
            }
            String sNowStart = DateUtil.getNowDateString("yyyyMMddHHmmss");
            withdrawReq.setB_serverDate(sNowStart.substring(0, 8));
            withdrawReq.setB_serverTime(sNowStart.substring(8));
            log.info((Object)"process produceBaseRouterCondition.");
            ResultData<BaseRouterCondition> rdRouterCondition = this.payChannelService.produceBaseRouterCondition(withdrawReq);
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdRouterCondition.getCode())) {
                return (WithdrawRes)TradeBeanUtil.produceResErr(withdrawReq, rdRouterCondition);
            }
            log.info((Object)"process queryPayChannel.");
            ResultData<PayChannelEnum> rdPayChannelEnum = this.payChannelService.queryPayChannel(rdRouterCondition.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelEnum.getCode())) {
                return (WithdrawRes)TradeBeanUtil.produceResErr(withdrawReq, rdPayChannelEnum);
            }
            log.info((Object)"process produceChannelReqBean.");
            ResultData<PayChannelBaseReq> rdPayChannelBaseReq = this.payChannelService.produceChannelReqBean(withdrawReq, rdPayChannelEnum.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseReq.getCode())) {
                return (WithdrawRes)TradeBeanUtil.produceResErr(withdrawReq, rdPayChannelBaseReq);
            }
            GatewayPayOrder gatewayPayOrder = this.payOrderService.produceAddPayOrder(withdrawReq, rdPayChannelEnum.getData(), rdPayChannelBaseReq.getData());
            int count = this.payOrderService.addPayOrder(gatewayPayOrder);
            if (count != 1) {
                ResultData rd = new ResultData();
                rd.setCode("E0000001");
                return (WithdrawRes)TradeBeanUtil.produceResErr(withdrawReq, rd);
            }
            log.info((Object)"process withdraw.");
            ResultData<PayChannelBaseRes> rdPayChannelBaseRes = this.payChannelService.withdraw(rdPayChannelBaseReq.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseRes.getCode())) {
                return (WithdrawRes)TradeBeanUtil.produceResErr(withdrawReq, rdPayChannelBaseRes);
            }
            log.info((Object)"process payChannelToPayRes.");
            ResultData<BaseRes> rdwithdrawRes = this.payChannelService.payChannelToBaseRes(rdPayChannelBaseRes.getData(), gatewayPayOrder.getPayOrderId(), gatewayPayOrder.getPayChannelOrderId());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdwithdrawRes.getCode())) {
                return (WithdrawRes)TradeBeanUtil.produceResErr(withdrawReq, rdwithdrawRes);
            }
            TradeBeanUtil.setRetComm(withdrawReq, rdwithdrawRes.getData());
            GatewayPayOrder gatewayPayOrderUpd = this.payOrderService.produceUpdatePayOrder(gatewayPayOrder.getPayOrderId(), rdPayChannelBaseRes.getData(), rdwithdrawRes.getData());
            if (gatewayPayOrderUpd == null) {
                ResultData rd = new ResultData();
                rd.setCode("W0000003");
                return (WithdrawRes)TradeBeanUtil.produceResErr(withdrawReq, rd);
            }
            count = this.payOrderService.updatePayOrder(gatewayPayOrderUpd);
            if (count != 1) {
                ResultData rd = new ResultData();
                rd.setCode("W0000002");
                return (WithdrawRes)TradeBeanUtil.produceResErr(withdrawReq, rd);
            }
            log.info((Object)("withdrawRes=" + ((WithdrawRes)rdwithdrawRes.getData()).toString()));
            log.info((Object)"withdraw end.");
            return (WithdrawRes)rdwithdrawRes.getData();
        }
        catch (Exception e) {
            log.error((Object)"\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            this.addExpInfo(withdrawReq.getB_merOrderId(), "", ResCodeEnum.ERROR.getCode(), e.toString());
            return (WithdrawRes)TradeBeanUtil.produceResCommWarn(withdrawReq);
        }
    }

    public QuickAuthSMSRes quickAuthSMS(QuickAuthSMSReq quickAuthSMSReq) {
        log.info((Object)"quickAuthSMS start.");
        log.info((Object)("quickAuthSMS=" + quickAuthSMSReq.toString()));
        try {
            ResultData<String> rdCheck = this.inputCheckService.quickAuthSMSCheck(quickAuthSMSReq);
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdCheck.getCode())) {
                QuickAuthSMSRes quickAuthSMSRes = (QuickAuthSMSRes)TradeBeanUtil.produceResErr(quickAuthSMSReq, rdCheck);
                log.info((Object)("\u8f93\u5165\u6821\u9a8c\u9519\u8bef\u3002quickAuthSMSRes=" + quickAuthSMSRes.toString()));
                return quickAuthSMSRes;
            }
            String sNowStart = DateUtil.getNowDateString("yyyyMMddHHmmss");
            quickAuthSMSReq.setB_serverDate(sNowStart.substring(0, 8));
            quickAuthSMSReq.setB_serverTime(sNowStart.substring(8));
            log.info((Object)"process produceBaseRouterCondition.");
            ResultData<BaseRouterCondition> rdRouterCondition = this.payChannelService.produceBaseRouterCondition(quickAuthSMSReq);
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdRouterCondition.getCode())) {
                return (QuickAuthSMSRes)TradeBeanUtil.produceResErr(quickAuthSMSReq, rdRouterCondition);
            }
            log.info((Object)"process queryPayChannel.");
            ResultData<PayChannelEnum> rdPayChannelEnum = this.payChannelService.queryPayChannel(rdRouterCondition.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelEnum.getCode())) {
                return (QuickAuthSMSRes)TradeBeanUtil.produceResErr(quickAuthSMSReq, rdPayChannelEnum);
            }
            log.info((Object)"process produceChannelReqBean.");
            ResultData<PayChannelBaseReq> rdPayChannelBaseReq = this.payChannelService.produceChannelReqBean(quickAuthSMSReq, rdPayChannelEnum.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseReq.getCode())) {
                return (QuickAuthSMSRes)TradeBeanUtil.produceResErr(quickAuthSMSReq, rdPayChannelBaseReq);
            }
            log.info((Object)"process quickAuthSMS.");
            ResultData<PayChannelBaseRes> rdPayChannelBaseRes = this.payChannelService.quickAuthSMS(rdPayChannelBaseReq.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseRes.getCode())) {
                return (QuickAuthSMSRes)TradeBeanUtil.produceResErr(quickAuthSMSReq, rdPayChannelBaseRes);
            }
            log.info((Object)"process payChannelToPayRes.");
            ResultData<BaseRes> rdQuickAuthSMSRes = this.payChannelService.payChannelToBaseRes(rdPayChannelBaseRes.getData(), "", "");
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdQuickAuthSMSRes.getCode())) {
                return (QuickAuthSMSRes)TradeBeanUtil.produceResErr(quickAuthSMSReq, rdQuickAuthSMSRes);
            }
            TradeBeanUtil.setRetComm(quickAuthSMSReq, rdQuickAuthSMSRes.getData());
            log.info((Object)("quickAuthSMSRes=" + ((QuickAuthSMSRes)rdQuickAuthSMSRes.getData()).toString()));
            log.info((Object)"quickAuthSMS end.");
            return (QuickAuthSMSRes)rdQuickAuthSMSRes.getData();
        }
        catch (Exception e) {
            log.error((Object)"\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            this.addExpInfo(quickAuthSMSReq.getB_merOrderId(), "", ResCodeEnum.ERROR.getCode(), e.toString());
            return (QuickAuthSMSRes)TradeBeanUtil.produceResCommWarn(quickAuthSMSReq);
        }
    }

    public QuickPayRes quickPay(QuickPayReq quickPayReq) {
        log.info((Object)"quickPay start.");
        log.info((Object)("quickPay=" + quickPayReq.toString()));
        try {
            ResultData<String> rdCheck = this.inputCheckService.quickPayCheck(quickPayReq);
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdCheck.getCode())) {
                QuickPayRes quickPayRes = (QuickPayRes)TradeBeanUtil.produceResErr(quickPayReq, rdCheck);
                log.info((Object)("\u8f93\u5165\u6821\u9a8c\u9519\u8bef\u3002quickPayRes=" + quickPayRes.toString()));
                return quickPayRes;
            }
            String sNowStart = DateUtil.getNowDateString("yyyyMMddHHmmss");
            quickPayReq.setB_serverDate(sNowStart.substring(0, 8));
            quickPayReq.setB_serverTime(sNowStart.substring(8));
            log.info((Object)"process produceBaseRouterCondition.");
            ResultData<BaseRouterCondition> rdRouterCondition = this.payChannelService.produceBaseRouterCondition(quickPayReq);
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdRouterCondition.getCode())) {
                return (QuickPayRes)TradeBeanUtil.produceResErr(quickPayReq, rdRouterCondition);
            }
            log.info((Object)"process queryPayChannel.");
            ResultData<PayChannelEnum> rdPayChannelEnum = this.payChannelService.queryPayChannel(rdRouterCondition.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelEnum.getCode())) {
                return (QuickPayRes)TradeBeanUtil.produceResErr(quickPayReq, rdPayChannelEnum);
            }
            log.info((Object)"process produceChannelReqBean.");
            ResultData<PayChannelBaseReq> rdPayChannelBaseReq = this.payChannelService.produceChannelReqBean(quickPayReq, rdPayChannelEnum.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseReq.getCode())) {
                return (QuickPayRes)TradeBeanUtil.produceResErr(quickPayReq, rdPayChannelBaseReq);
            }
            GatewayPayOrder gatewayPayOrder = this.payOrderService.produceAddPayOrder(quickPayReq, rdPayChannelEnum.getData(), rdPayChannelBaseReq.getData());
            int count = this.payOrderService.addPayOrder(gatewayPayOrder);
            if (count != 1) {
                ResultData rd = new ResultData();
                rd.setCode("E0000001");
                return (QuickPayRes)TradeBeanUtil.produceResErr(quickPayReq, rd);
            }
            log.info((Object)"process quickPay.");
            ResultData<PayChannelBaseRes> rdPayChannelBaseRes = this.payChannelService.quickPay(rdPayChannelBaseReq.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseRes.getCode())) {
                return (QuickPayRes)TradeBeanUtil.produceResErr(quickPayReq, rdPayChannelBaseRes);
            }
            log.info((Object)"process payChannelToPayRes.");
            ResultData<BaseRes> rdQuickPayRes = this.payChannelService.payChannelToBaseRes(rdPayChannelBaseRes.getData(), gatewayPayOrder.getPayOrderId(), "");
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdQuickPayRes.getCode())) {
                return (QuickPayRes)TradeBeanUtil.produceResErr(quickPayReq, rdQuickPayRes);
            }
            TradeBeanUtil.setRetComm(quickPayReq, rdQuickPayRes.getData());
            GatewayPayOrder gatewayPayOrderUpd = this.payOrderService.produceUpdatePayOrder(gatewayPayOrder.getPayOrderId(), rdPayChannelBaseRes.getData(), rdQuickPayRes.getData());
            if (gatewayPayOrderUpd == null) {
                ResultData rd = new ResultData();
                rd.setCode("W0000003");
                return (QuickPayRes)TradeBeanUtil.produceResErr(quickPayReq, rd);
            }
            count = this.payOrderService.updatePayOrder(gatewayPayOrderUpd);
            if (count != 1) {
                ResultData rd = new ResultData();
                rd.setCode("W0000002");
                return (QuickPayRes)TradeBeanUtil.produceResErr(quickPayReq, rd);
            }
            log.info((Object)("quickPayRes=" + ((QuickPayRes)rdQuickPayRes.getData()).toString()));
            log.info((Object)"quickPay end.");
            return (QuickPayRes)rdQuickPayRes.getData();
        }
        catch (Exception e) {
            log.error((Object)"\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            this.addExpInfo(quickPayReq.getB_merOrderId(), "", ResCodeEnum.ERROR.getCode(), e.toString());
            return (QuickPayRes)TradeBeanUtil.produceResCommWarn(quickPayReq);
        }
    }

    public VerCodeSendRes verCodeSend(VerCodeSendReq verCodeSendReq) {
        log.info((Object)"verCodeSend start.");
        log.info((Object)("verCodeSend=" + verCodeSendReq.toString()));
        try {
            ResultData<String> rdCheck = this.inputCheckService.verCodeSendCheck(verCodeSendReq);
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdCheck.getCode())) {
                VerCodeSendRes verCodeSendRes = (VerCodeSendRes)TradeBeanUtil.produceResErr(verCodeSendReq, rdCheck);
                log.info((Object)("\u8f93\u5165\u6821\u9a8c\u9519\u8bef\u3002verCodeSendRes=" + verCodeSendRes.toString()));
                return verCodeSendRes;
            }
            String sNowStart = DateUtil.getNowDateString("yyyyMMddHHmmss");
            verCodeSendReq.setB_serverDate(sNowStart.substring(0, 8));
            verCodeSendReq.setB_serverTime(sNowStart.substring(8));
            log.info((Object)"process produceBaseRouterCondition.");
            ResultData<BaseRouterCondition> rdRouterCondition = this.payChannelService.produceBaseRouterCondition(verCodeSendReq);
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdRouterCondition.getCode())) {
                return (VerCodeSendRes)TradeBeanUtil.produceResErr(verCodeSendReq, rdRouterCondition);
            }
            log.info((Object)"process queryPayChannel.");
            ResultData<PayChannelEnum> rdPayChannelEnum = this.payChannelService.queryPayChannel(rdRouterCondition.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelEnum.getCode())) {
                return (VerCodeSendRes)TradeBeanUtil.produceResErr(verCodeSendReq, rdPayChannelEnum);
            }
            log.info((Object)"process produceChannelReqBean.");
            ResultData<PayChannelBaseReq> rdPayChannelBaseReq = this.payChannelService.produceChannelReqBean(verCodeSendReq, rdPayChannelEnum.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseReq.getCode())) {
                return (VerCodeSendRes)TradeBeanUtil.produceResErr(verCodeSendReq, rdPayChannelBaseReq);
            }
            log.info((Object)"process verCodeSend.");
            ResultData<PayChannelBaseRes> rdPayChannelBaseRes = this.payChannelService.verCodeSend(rdPayChannelBaseReq.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseRes.getCode())) {
                return (VerCodeSendRes)TradeBeanUtil.produceResErr(verCodeSendReq, rdPayChannelBaseRes);
            }
            log.info((Object)"process payChannelToPayRes.");
            ResultData<BaseRes> rdVerCodeSendRes = this.payChannelService.payChannelToBaseRes(rdPayChannelBaseRes.getData(), "", "");
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdVerCodeSendRes.getCode())) {
                return (VerCodeSendRes)TradeBeanUtil.produceResErr(verCodeSendReq, rdVerCodeSendRes);
            }
            TradeBeanUtil.setRetComm(verCodeSendReq, rdVerCodeSendRes.getData());
            log.info((Object)("verCodeSendRes=" + ((VerCodeSendRes)rdVerCodeSendRes.getData()).toString()));
            log.info((Object)"verCodeSend end.");
            return (VerCodeSendRes)rdVerCodeSendRes.getData();
        }
        catch (Exception e) {
            log.error((Object)"\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            this.addExpInfo(verCodeSendReq.getB_merOrderId(), "", ResCodeEnum.ERROR.getCode(), e.toString());
            return (VerCodeSendRes)TradeBeanUtil.produceResCommWarn(verCodeSendReq);
        }
    }

    public IdentityAuthRes identityAuth(IdentityAuthReq identityAuthReq) {
        log.info((Object)"identityAuth start.");
        log.info((Object)("identityAuth=" + identityAuthReq.toString()));
        try {
            ResultData<String> rdCheck = this.inputCheckService.identityAuthCheck(identityAuthReq);
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdCheck.getCode())) {
                IdentityAuthRes identityAuthRes = (IdentityAuthRes)TradeBeanUtil.produceResErr(identityAuthReq, rdCheck);
                log.info((Object)("\u8f93\u5165\u6821\u9a8c\u9519\u8bef\u3002identityAuthRes=" + identityAuthRes.toString()));
                return identityAuthRes;
            }
            String sNowStart = DateUtil.getNowDateString("yyyyMMddHHmmss");
            identityAuthReq.setB_serverDate(sNowStart.substring(0, 8));
            identityAuthReq.setB_serverTime(sNowStart.substring(8));
            log.info((Object)"process produceBaseRouterCondition.");
            ResultData<BaseRouterCondition> rdRouterCondition = this.payChannelService.produceBaseRouterCondition(identityAuthReq);
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdRouterCondition.getCode())) {
                return (IdentityAuthRes)TradeBeanUtil.produceResErr(identityAuthReq, rdRouterCondition);
            }
            log.info((Object)"process queryPayChannel.");
            ResultData<PayChannelEnum> rdPayChannelEnum = this.payChannelService.queryPayChannel(rdRouterCondition.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelEnum.getCode())) {
                return (IdentityAuthRes)TradeBeanUtil.produceResErr(identityAuthReq, rdPayChannelEnum);
            }
            log.info((Object)"process produceChannelReqBean.");
            ResultData<PayChannelBaseReq> rdPayChannelBaseReq = this.payChannelService.produceChannelReqBean(identityAuthReq, rdPayChannelEnum.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseReq.getCode())) {
                return (IdentityAuthRes)TradeBeanUtil.produceResErr(identityAuthReq, rdPayChannelBaseReq);
            }
            log.info((Object)"process identityAuth.");
            ResultData<PayChannelBaseRes> rdPayChannelBaseRes = this.payChannelService.identityAuth(rdPayChannelBaseReq.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseRes.getCode())) {
                return (IdentityAuthRes)TradeBeanUtil.produceResErr(identityAuthReq, rdPayChannelBaseRes);
            }
            log.info((Object)"process payChannelToPayRes.");
            ResultData<BaseRes> rdIdentityAuthRes = this.payChannelService.payChannelToBaseRes(rdPayChannelBaseRes.getData(), "", "");
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdIdentityAuthRes.getCode())) {
                return (IdentityAuthRes)TradeBeanUtil.produceResErr(identityAuthReq, rdIdentityAuthRes);
            }
            TradeBeanUtil.setRetComm(identityAuthReq, rdIdentityAuthRes.getData());
            log.info((Object)("identityAuthRes=" + ((IdentityAuthRes)rdIdentityAuthRes.getData()).toString()));
            log.info((Object)"identityAuth end.");
            return (IdentityAuthRes)rdIdentityAuthRes.getData();
        }
        catch (Exception e) {
            log.error((Object)"\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            this.addExpInfo(identityAuthReq.getB_merOrderId(), "", ResCodeEnum.ERROR.getCode(), e.toString());
            return (IdentityAuthRes)TradeBeanUtil.produceResCommWarn(identityAuthReq);
        }
    }

    public SingleTradeQueryRes singleTradeQuery(SingleTradeQueryReq singleTradeQueryReq) {
        log.info((Object)"singleTradeQuery start.");
        log.info((Object)("singleTradeQuery=" + singleTradeQueryReq.toString()));
        try {
            ResultData<String> rdCheck = this.inputCheckService.singleTradeQueryCheck(singleTradeQueryReq);
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdCheck.getCode())) {
                SingleTradeQueryRes singleTradeQueryRes = (SingleTradeQueryRes)TradeBeanUtil.produceResErr(singleTradeQueryReq, rdCheck);
                log.info((Object)("\u8f93\u5165\u6821\u9a8c\u9519\u8bef\u3002singleTradeQueryRes=" + singleTradeQueryRes.toString()));
                return singleTradeQueryRes;
            }
            String sNowStart = DateUtil.getNowDateString("yyyyMMddHHmmss");
            singleTradeQueryReq.setB_serverDate(sNowStart.substring(0, 8));
            singleTradeQueryReq.setB_serverTime(sNowStart.substring(8));
            log.info((Object)"process produceBaseRouterCondition.");
            ResultData<BaseRouterCondition> rdRouterCondition = this.payChannelService.produceBaseRouterCondition(singleTradeQueryReq);
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdRouterCondition.getCode())) {
                return (SingleTradeQueryRes)TradeBeanUtil.produceResErr(singleTradeQueryReq, rdRouterCondition);
            }
            log.info((Object)"process queryPayChannel.");
            ResultData<PayChannelEnum> rdPayChannelEnum = this.payChannelService.queryPayChannel(rdRouterCondition.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelEnum.getCode())) {
                return (SingleTradeQueryRes)TradeBeanUtil.produceResErr(singleTradeQueryReq, rdPayChannelEnum);
            }
            log.info((Object)"process produceChannelReqBean.");
            ResultData<PayChannelBaseReq> rdPayChannelBaseReq = this.payChannelService.produceChannelReqBean(singleTradeQueryReq, rdPayChannelEnum.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseReq.getCode())) {
                return (SingleTradeQueryRes)TradeBeanUtil.produceResErr(singleTradeQueryReq, rdPayChannelBaseReq);
            }
            log.info((Object)"process singleTradeQuery.");
            ResultData<PayChannelBaseRes> rdPayChannelBaseRes = this.payChannelService.singleTradeQuery(rdPayChannelBaseReq.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseRes.getCode())) {
                return (SingleTradeQueryRes)TradeBeanUtil.produceResErr(singleTradeQueryReq, rdPayChannelBaseRes);
            }
            log.info((Object)"process payChannelToPayRes.");
            ResultData<BaseRes> rdSingleTradeQueryRes = this.payChannelService.payChannelToBaseRes(rdPayChannelBaseRes.getData(), "", "");
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdSingleTradeQueryRes.getCode())) {
                return (SingleTradeQueryRes)TradeBeanUtil.produceResErr(singleTradeQueryReq, rdSingleTradeQueryRes);
            }
            TradeBeanUtil.setRetComm(singleTradeQueryReq, rdSingleTradeQueryRes.getData());
            log.info((Object)("singleTradeQueryRes=" + ((SingleTradeQueryRes)rdSingleTradeQueryRes.getData()).toString()));
            log.info((Object)"singleTradeQuery end.");
            return (SingleTradeQueryRes)rdSingleTradeQueryRes.getData();
        }
        catch (Exception e) {
            log.error((Object)"\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            this.addExpInfo(singleTradeQueryReq.getB_merOrderId(), "", ResCodeEnum.ERROR.getCode(), e.toString());
            return (SingleTradeQueryRes)TradeBeanUtil.produceResCommWarn(singleTradeQueryReq);
        }
    }

    public BalanceQueryRes balanceQuery(BalanceQueryReq balanceQueryReq) {
        log.info((Object)"balanceQuery start.");
        log.info((Object)("balanceQueryReq=" + balanceQueryReq.toString()));
        try {
            ResultData<String> rdCheck = this.inputCheckService.balanceQueryCheck(balanceQueryReq);
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdCheck.getCode())) {
                BalanceQueryRes balanceQueryRes = (BalanceQueryRes)TradeBeanUtil.produceResErr(balanceQueryReq, rdCheck);
                log.info((Object)("\u8f93\u5165\u6821\u9a8c\u9519\u8bef\u3002balanceQueryRes=" + balanceQueryRes.toString()));
                return balanceQueryRes;
            }
            String sNowStart = DateUtil.getNowDateString("yyyyMMddHHmmss");
            balanceQueryReq.setB_serverDate(sNowStart.substring(0, 8));
            balanceQueryReq.setB_serverTime(sNowStart.substring(8));
            ResultData<PayChannelEnum> rdPayChannelEnum = new ResultData<PayChannelEnum>();
            rdPayChannelEnum.setData(PayChannelEnum.AGENT_PAY);
            log.info((Object)"process produceChannelReqBean.");
            ResultData<PayChannelBaseReq> rdPayChannelBaseReq = this.payChannelService.produceChannelReqBean(balanceQueryReq, (PayChannelEnum)((Object)rdPayChannelEnum.getData()));
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseReq.getCode())) {
                return (BalanceQueryRes)TradeBeanUtil.produceResErr(balanceQueryReq, rdPayChannelBaseReq);
            }
            log.info((Object)"process balanceQuery.");
            ResultData<PayChannelBaseRes> rdPayChannelBaseRes = this.payChannelService.balanceQuery(rdPayChannelBaseReq.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseRes.getCode())) {
                return (BalanceQueryRes)TradeBeanUtil.produceResErr(balanceQueryReq, rdPayChannelBaseRes);
            }
            log.info((Object)"process payChannelToPayRes.");
            ResultData<BaseRes> rdBalanceQueryRes = this.payChannelService.payChannelToBaseRes(rdPayChannelBaseRes.getData(), "", "");
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdBalanceQueryRes.getCode())) {
                return (BalanceQueryRes)TradeBeanUtil.produceResErr(balanceQueryReq, rdBalanceQueryRes);
            }
            TradeBeanUtil.setRetComm(balanceQueryReq, rdBalanceQueryRes.getData());
            log.info((Object)("balanceQueryRes=" + ((BalanceQueryRes)rdBalanceQueryRes.getData()).toString()));
            log.info((Object)"balanceQuery end.");
            return (BalanceQueryRes)rdBalanceQueryRes.getData();
        }
        catch (Exception e) {
            log.error((Object)"\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            this.addExpInfo(balanceQueryReq.getB_merOrderId(), "", ResCodeEnum.ERROR.getCode(), e.toString());
            return (BalanceQueryRes)TradeBeanUtil.produceResCommWarn(balanceQueryReq);
        }
    }

    public TradeDetailQueryRes tradeDetailQuery(TradeDetailQueryReq tradeDetailQueryReq) {
        log.info((Object)"tradeDetailQuery start.");
        log.info((Object)("tradeDetailQueryReq=" + tradeDetailQueryReq.toString()));
        try {
            ResultData<String> rdCheck = this.inputCheckService.tradeDetailQueryCheck(tradeDetailQueryReq);
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdCheck.getCode())) {
                TradeDetailQueryRes tradeDetailQueryRes = (TradeDetailQueryRes)TradeBeanUtil.produceResErr(tradeDetailQueryReq, rdCheck);
                log.info((Object)("\u8f93\u5165\u6821\u9a8c\u9519\u8bef\u3002tradeDetailQueryRes=" + tradeDetailQueryRes.toString()));
                return tradeDetailQueryRes;
            }
            String sNowStart = DateUtil.getNowDateString("yyyyMMddHHmmss");
            tradeDetailQueryReq.setB_serverDate(sNowStart.substring(0, 8));
            tradeDetailQueryReq.setB_serverTime(sNowStart.substring(8));
            ResultData<PayChannelEnum> rdPayChannelEnum = new ResultData<PayChannelEnum>();
            rdPayChannelEnum.setData(PayChannelEnum.AGENT_PAY);
            log.info((Object)"process produceChannelReqBean.");
            ResultData<PayChannelBaseReq> rdPayChannelBaseReq = this.payChannelService.produceChannelReqBean(tradeDetailQueryReq, (PayChannelEnum)((Object)rdPayChannelEnum.getData()));
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseReq.getCode())) {
                return (TradeDetailQueryRes)TradeBeanUtil.produceResErr(tradeDetailQueryReq, rdPayChannelBaseReq);
            }
            log.info((Object)"process balanceQuery.");
            ResultData<PayChannelBaseRes> rdPayChannelBaseRes = this.payChannelService.tradeDetailQuery(rdPayChannelBaseReq.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseRes.getCode())) {
                return (TradeDetailQueryRes)TradeBeanUtil.produceResErr(tradeDetailQueryReq, rdPayChannelBaseRes);
            }
            log.info((Object)"process tradeDetailQueryRes.");
            ResultData<BaseRes> rdTradeDetailQueryRes = this.payChannelService.payChannelToBaseRes(rdPayChannelBaseRes.getData(), "", "");
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdTradeDetailQueryRes.getCode())) {
                return (TradeDetailQueryRes)TradeBeanUtil.produceResErr(tradeDetailQueryReq, rdTradeDetailQueryRes);
            }
            TradeBeanUtil.setRetComm(tradeDetailQueryReq, rdTradeDetailQueryRes.getData());
            log.info((Object)("tradeDetailQueryRes=" + ((TradeDetailQueryRes)rdTradeDetailQueryRes.getData()).toString()));
            log.info((Object)"tradeDetailQuery end.");
            return (TradeDetailQueryRes)rdTradeDetailQueryRes.getData();
        }
        catch (Exception e) {
            log.error((Object)"\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            this.addExpInfo(tradeDetailQueryReq.getB_merOrderId(), "", ResCodeEnum.ERROR.getCode(), e.toString());
            return (TradeDetailQueryRes)TradeBeanUtil.produceResCommWarn(tradeDetailQueryReq);
        }
    }

    public MoneyRecordQueryRes moneyRecordQuery(MoneyRecordQueryReq moneyRecordQueryReq) {
        log.info((Object)"moneyRecordQuery start.");
        log.info((Object)("moneyRecordQueryReq=" + moneyRecordQueryReq.toString()));
        try {
            ResultData<String> rdCheck = this.inputCheckService.moneyRecordQueryCheck(moneyRecordQueryReq);
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdCheck.getCode())) {
                MoneyRecordQueryRes moneyRecordQueryRes = (MoneyRecordQueryRes)TradeBeanUtil.produceResErr(moneyRecordQueryReq, rdCheck);
                log.info((Object)("\u8f93\u5165\u6821\u9a8c\u9519\u8bef\u3002moneyRecordQueryRes=" + moneyRecordQueryRes.toString()));
                return moneyRecordQueryRes;
            }
            String sNowStart = DateUtil.getNowDateString("yyyyMMddHHmmss");
            moneyRecordQueryReq.setB_serverDate(sNowStart.substring(0, 8));
            moneyRecordQueryReq.setB_serverTime(sNowStart.substring(8));
            ResultData<PayChannelEnum> rdPayChannelEnum = new ResultData<PayChannelEnum>();
            rdPayChannelEnum.setData(PayChannelEnum.AGENT_PAY);
            log.info((Object)"process produceChannelReqBean.");
            ResultData<PayChannelBaseReq> rdPayChannelBaseReq = this.payChannelService.produceChannelReqBean(moneyRecordQueryReq, (PayChannelEnum)((Object)rdPayChannelEnum.getData()));
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseReq.getCode())) {
                return (MoneyRecordQueryRes)TradeBeanUtil.produceResErr(moneyRecordQueryReq, rdPayChannelBaseReq);
            }
            log.info((Object)"process moneyRecordQuery.");
            ResultData<PayChannelBaseRes> rdPayChannelBaseRes = this.payChannelService.moneyRecordQuery(rdPayChannelBaseReq.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseRes.getCode())) {
                return (MoneyRecordQueryRes)TradeBeanUtil.produceResErr(moneyRecordQueryReq, rdPayChannelBaseRes);
            }
            log.info((Object)"process moneyRecordQueryRes.");
            ResultData<BaseRes> rdMoneyRecordQueryRes = this.payChannelService.payChannelToBaseRes(rdPayChannelBaseRes.getData(), "", "");
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdMoneyRecordQueryRes.getCode())) {
                return (MoneyRecordQueryRes)TradeBeanUtil.produceResErr(moneyRecordQueryReq, rdMoneyRecordQueryRes);
            }
            TradeBeanUtil.setRetComm(moneyRecordQueryReq, rdMoneyRecordQueryRes.getData());
            log.info((Object)("moneyRecordQueryRes=" + ((MoneyRecordQueryRes)rdMoneyRecordQueryRes.getData()).toString()));
            log.info((Object)"moneyRecordQuery end.");
            return (MoneyRecordQueryRes)rdMoneyRecordQueryRes.getData();
        }
        catch (Exception e) {
            log.error((Object)"\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            this.addExpInfo(moneyRecordQueryReq.getB_merOrderId(), "", ResCodeEnum.ERROR.getCode(), e.toString());
            return (MoneyRecordQueryRes)TradeBeanUtil.produceResCommWarn(moneyRecordQueryReq);
        }
    }

    public IdentityAuthQueryRes identityAuthQuery(IdentityAuthQueryReq identityAuthQueryReq) {
        log.info((Object)"identityAuthQuery start.");
        log.info((Object)("identityAuthQueryReq=" + identityAuthQueryReq.toString()));
        try {
            ResultData<String> rdCheck = this.inputCheckService.identityAuthQueryCheck(identityAuthQueryReq);
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdCheck.getCode())) {
                IdentityAuthQueryRes identityAuthQueryRes = (IdentityAuthQueryRes)TradeBeanUtil.produceResErr(identityAuthQueryReq, rdCheck);
                log.info((Object)("\u8f93\u5165\u6821\u9a8c\u9519\u8bef\u3002identityAuthQueryRes=" + identityAuthQueryRes.toString()));
                return identityAuthQueryRes;
            }
            String sNowStart = DateUtil.getNowDateString("yyyyMMddHHmmss");
            identityAuthQueryReq.setB_serverDate(sNowStart.substring(0, 8));
            identityAuthQueryReq.setB_serverTime(sNowStart.substring(8));
            ResultData<PayChannelEnum> rdPayChannelEnum = new ResultData<PayChannelEnum>();
            rdPayChannelEnum.setData(PayChannelEnum.AGENT_PAY);
            log.info((Object)"process produceChannelReqBean.");
            ResultData<PayChannelBaseReq> rdPayChannelBaseReq = this.payChannelService.produceChannelReqBean(identityAuthQueryReq, (PayChannelEnum)((Object)rdPayChannelEnum.getData()));
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseReq.getCode())) {
                return (IdentityAuthQueryRes)TradeBeanUtil.produceResErr(identityAuthQueryReq, rdPayChannelBaseReq);
            }
            log.info((Object)"process identityAuthQuery.");
            ResultData<PayChannelBaseRes> rdPayChannelBaseRes = this.payChannelService.identityAuthQuery(rdPayChannelBaseReq.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseRes.getCode())) {
                return (IdentityAuthQueryRes)TradeBeanUtil.produceResErr(identityAuthQueryReq, rdPayChannelBaseRes);
            }
            log.info((Object)"process identityAuthQueryRes.");
            ResultData<BaseRes> rdIdentityAuthQueryRes = this.payChannelService.payChannelToBaseRes(rdPayChannelBaseRes.getData(), "", "");
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdIdentityAuthQueryRes.getCode())) {
                return (IdentityAuthQueryRes)TradeBeanUtil.produceResErr(identityAuthQueryReq, rdIdentityAuthQueryRes);
            }
            TradeBeanUtil.setRetComm(identityAuthQueryReq, rdIdentityAuthQueryRes.getData());
            log.info((Object)("identityAuthQueryRes=" + ((IdentityAuthQueryRes)rdIdentityAuthQueryRes.getData()).toString()));
            log.info((Object)"identityAuthQuery end.");
            return (IdentityAuthQueryRes)rdIdentityAuthQueryRes.getData();
        }
        catch (Exception e) {
            log.error((Object)"\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            this.addExpInfo(identityAuthQueryReq.getB_merOrderId(), "", ResCodeEnum.ERROR.getCode(), e.toString());
            return (IdentityAuthQueryRes)TradeBeanUtil.produceResCommWarn(identityAuthQueryReq);
        }
    }

    public SingleNoticeRes singleNotice(SingleNoticeReq singleNoticeReq) {
        log.info((Object)"singleNotice start.");
        log.info((Object)("singleNoticeReq=" + singleNoticeReq.toString()));
        try {
            ResultData<String> rdCheck = this.inputCheckService.singleNoticeCheck(singleNoticeReq);
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdCheck.getCode())) {
                SingleNoticeRes singleNoticeRes = (SingleNoticeRes)TradeBeanUtil.produceResErr(singleNoticeReq, rdCheck);
                log.info((Object)("\u8f93\u5165\u6821\u9a8c\u9519\u8bef\u3002singleNoticeRes=" + singleNoticeRes.toString()));
                return singleNoticeRes;
            }
            String sNowStart = DateUtil.getNowDateString("yyyyMMddHHmmss");
            singleNoticeReq.setB_serverDate(sNowStart.substring(0, 8));
            singleNoticeReq.setB_serverTime(sNowStart.substring(8));
            ResultData<PayChannelEnum> rdPayChannelEnum = new ResultData<PayChannelEnum>();
            rdPayChannelEnum.setData(PayChannelEnum.AGENT_PAY);
            log.info((Object)"process produceChannelReqBean.");
            ResultData<PayChannelBaseReq> rdPayChannelBaseReq = this.payChannelService.produceChannelReqBean(singleNoticeReq, (PayChannelEnum)((Object)rdPayChannelEnum.getData()));
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseReq.getCode())) {
                return (SingleNoticeRes)TradeBeanUtil.produceResErr(singleNoticeReq, rdPayChannelBaseReq);
            }
            log.info((Object)"process singleNotice.");
            ResultData<PayChannelBaseRes> rdPayChannelBaseRes = this.payChannelService.singleNotice(rdPayChannelBaseReq.getData());
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdPayChannelBaseRes.getCode())) {
                return (SingleNoticeRes)TradeBeanUtil.produceResErr(singleNoticeReq, rdPayChannelBaseRes);
            }
            log.info((Object)"process payChannelToPayRes.");
            ResultData<BaseRes> rdSingleNoticeRes = this.payChannelService.payChannelToBaseRes(rdPayChannelBaseRes.getData(), "", "");
            if (!ResCodeEnum.SUCCESS.getCode().equals(rdSingleNoticeRes.getCode())) {
                return (SingleNoticeRes)TradeBeanUtil.produceResErr(singleNoticeReq, rdSingleNoticeRes);
            }
            TradeBeanUtil.setRetComm(singleNoticeReq, rdSingleNoticeRes.getData());
            SingleNoticeRes singleNoticeRes = (SingleNoticeRes)rdSingleNoticeRes.getData();
            if (ResCodeEnum.SUCCESS.getCode().equals(singleNoticeRes.getTranResCode()) && (ResStateEnum.S.getCode().equals(singleNoticeRes.getTranState()) || ResStateEnum.E.getCode().equals(singleNoticeRes.getTranState()))) {
                GatewayPayOrder gatewayPayOrderUpd = this.payOrderService.produceUpdatePayOrder(singleNoticeRes.getB_orderId(), rdPayChannelBaseRes.getData(), rdSingleNoticeRes.getData());
                if (gatewayPayOrderUpd == null) {
                    ResultData rd = new ResultData();
                    rd.setCode("W0000003");
                    return (SingleNoticeRes)TradeBeanUtil.produceResErr(singleNoticeReq, rd);
                }
                int count = this.payOrderService.updatePayOrderWithState(gatewayPayOrderUpd);
                if (count != 1) {
                    ResultData rd = new ResultData();
                    rd.setCode("W0000002");
                    return (SingleNoticeRes)TradeBeanUtil.produceResErr(singleNoticeReq, rd);
                }
            }
            log.info((Object)("singleNoticeRes=" + ((SingleNoticeRes)rdSingleNoticeRes.getData()).toString()));
            log.info((Object)"singleNotice end.");
            return (SingleNoticeRes)rdSingleNoticeRes.getData();
        }
        catch (Exception e) {
            log.error((Object)"\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            this.addExpInfo(singleNoticeReq.getB_merOrderId(), "", ResCodeEnum.ERROR.getCode(), e.toString());
            SingleNoticeRes singleNoticeRes = (SingleNoticeRes)TradeBeanUtil.produceResCommWarn(singleNoticeReq);
            log.error((Object)("singleNoticeRes=" + singleNoticeRes.toString()));
            return singleNoticeRes;
        }
    }

    private int addExpInfo(String merOrderId, String payOrderId, String errCode, String expInfo) {
        GatewayExpInfo gatewayExpInfo = new GatewayExpInfo();
        gatewayExpInfo.setMerOrderId(merOrderId);
        gatewayExpInfo.setPayOrderId(payOrderId);
        gatewayExpInfo.setErrCode(errCode);
        gatewayExpInfo.setExpInfo(expInfo.getBytes());
        gatewayExpInfo.setCreateTime(new Date());
        int cnt = 0;
        try {
            cnt = this.expInfoService.addExpInfo(gatewayExpInfo);
        }
        catch (Exception e) {
            log.error((Object)"\u5f02\u5e38\u65e5\u5fd7\u5199\u5165\u9519\u8bef", (Throwable)e);
        }
        return cnt;
    }
}

