/*
 * Decompiled with CFR 0.152.
 */
package com.msyd.gateway.service.impl;

import com.msyd.gateway.bean.req.BalanceQueryReq;
import com.msyd.gateway.bean.req.BaseReq;
import com.msyd.gateway.bean.req.IdentityAuthQueryReq;
import com.msyd.gateway.bean.req.IdentityAuthReq;
import com.msyd.gateway.bean.req.MoneyRecordQueryReq;
import com.msyd.gateway.bean.req.PayReq;
import com.msyd.gateway.bean.req.QuickAuthSMSReq;
import com.msyd.gateway.bean.req.QuickPayReq;
import com.msyd.gateway.bean.req.SingleNoticeReq;
import com.msyd.gateway.bean.req.SingleTradeQueryReq;
import com.msyd.gateway.bean.req.TradeDetailQueryReq;
import com.msyd.gateway.bean.req.VerCodeSendReq;
import com.msyd.gateway.bean.req.WithdrawReq;
import com.msyd.gateway.dao.map.GatewayMerchantInfo;
import com.msyd.gateway.enums.ResCodeEnum;
import com.msyd.gateway.enums.ResStateEnum;
import com.msyd.gateway.enums.SubTranCodeEnum;
import com.msyd.gateway.enums.TranCodeEnum;
import com.msyd.gateway.message.ResultData;
import com.msyd.gateway.service.InputCheckService;
import com.msyd.gateway.service.MerchantService;
import com.msyd.gateway.utils.CheckUtil;
import com.msyd.gateway.utils.StringUtil;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="inputCheckService")
public class InputCheckServiceImpl
implements InputCheckService {
    @Resource
    MerchantService merchantService;

    @Override
    public ResultData<String> baseCheck(BaseReq baseReq) {
        ResultData<String> rd = new ResultData<String>();
        if (baseReq == null) {
            rd.setCode("EIPT0000");
            return rd;
        }
        if (StringUtil.isEmpty(baseReq.getB_version())) {
            rd.setCode("EIPT0001");
            return rd;
        }
        if (!"01".equals(baseReq.getB_version())) {
            rd.setCode("EIPT0002");
            return rd;
        }
        if (StringUtil.isEmpty(baseReq.getB_merchantNo())) {
            rd.setCode("EIPT0011");
            return rd;
        }
        if (baseReq.getB_merchantNo().length() != 8) {
            rd.setCode("EIPT0012");
            return rd;
        }
        GatewayMerchantInfo gmi = this.merchantService.queryMerchantById(baseReq.getB_merchantNo());
        if (gmi == null || StringUtil.isEmpty(gmi.getMerchantNo())) {
            rd.setCode("EIPT0013");
            return rd;
        }
        if (StringUtil.isEmpty(baseReq.getB_merOrderId())) {
            rd.setCode("EIPT0021");
            return rd;
        }
        if (!baseReq.getB_merOrderId().startsWith(gmi.getMerchantNo())) {
            rd.setCode("EIPT0022");
            return rd;
        }
        if (StringUtil.isEmpty(baseReq.getB_tranCode())) {
            rd.setCode("EIPT0031");
            return rd;
        }
        if (TranCodeEnum.getByCode(baseReq.getB_tranCode()) == null) {
            rd.setCode("EIPT0032");
            return rd;
        }
        if (StringUtil.isEmpty(baseReq.getB_clientDate())) {
            rd.setCode("EIPT0051");
            return rd;
        }
        if (!CheckUtil.isNumber(baseReq.getB_clientDate(), 8)) {
            rd.setCode("EIPT0052");
            return rd;
        }
        if (StringUtil.isEmpty(baseReq.getB_clientTime())) {
            rd.setCode("EIPT0061");
            return rd;
        }
        if (!CheckUtil.isNumber(baseReq.getB_clientTime(), 6)) {
            rd.setCode("EIPT0062");
            return rd;
        }
        return rd;
    }

    @Override
    public ResultData<String> payCheck(PayReq payReq) {
        ResultData<String> rd = this.baseCheck(payReq);
        if (!ResCodeEnum.SUCCESS.getCode().equals(rd.getCode())) {
            return rd;
        }
        if (!TranCodeEnum.PAY.getCode().equals(payReq.getB_tranCode())) {
            rd.setCode("EIPT0033");
            return rd;
        }
        if (StringUtil.isEmpty(payReq.getBankName())) {
            rd.setCode("EIPT0101");
            return rd;
        }
        if (StringUtil.isEmpty(payReq.getAccountNo())) {
            rd.setCode("EIPT0102");
            return rd;
        }
        if (StringUtil.isEmpty(payReq.getAccountName())) {
            rd.setCode("EIPT0103");
            return rd;
        }
        if (StringUtil.isEmpty(payReq.getAccountType())) {
            rd.setCode("EIPT0104");
            return rd;
        }
        if (!"00".equals(payReq.getAccountType()) && !"01".equals(payReq.getAccountType())) {
            rd.setCode("EIPT0105");
            return rd;
        }
        if (payReq.getTradeAmount() == null || payReq.getTradeAmount().compareTo(BigDecimal.ZERO) < 0) {
            rd.setCode("EIPT0106");
            return rd;
        }
        if (payReq.getTradeAmount() == null || !payReq.getCurrency().equals("CNY")) {
            rd.setCode("EIPT0107");
            return rd;
        }
        if (StringUtil.isEmpty(payReq.getBsnType())) {
            rd.setCode("EIPT0108");
            return rd;
        }
        return rd;
    }

    @Override
    public ResultData<String> withdrawCheck(WithdrawReq withdrawReq) {
        ResultData<String> rd = this.baseCheck(withdrawReq);
        if (!ResCodeEnum.SUCCESS.getCode().equals(rd.getCode())) {
            return rd;
        }
        if (!TranCodeEnum.WITHDRAW.getCode().equals(withdrawReq.getB_tranCode())) {
            rd.setCode("EIPT0033");
            return rd;
        }
        if (StringUtil.isEmpty(withdrawReq.getB_subTranCode())) {
            rd.setCode("EIPT0041");
            return rd;
        }
        if (!SubTranCodeEnum.SUB_01.getCode().equals(withdrawReq.getB_subTranCode()) && !SubTranCodeEnum.SUB_02.getCode().equals(withdrawReq.getB_subTranCode())) {
            rd.setCode("EIPT0042");
            return rd;
        }
        if (StringUtil.isEmpty(withdrawReq.getBankName())) {
            rd.setCode("EIPT0101");
            return rd;
        }
        if (StringUtil.isEmpty(withdrawReq.getAccountNo())) {
            rd.setCode("EIPT0102");
            return rd;
        }
        if (StringUtil.isEmpty(withdrawReq.getAccountName())) {
            rd.setCode("EIPT0103");
            return rd;
        }
        if (StringUtil.isEmpty(withdrawReq.getAccountType())) {
            rd.setCode("EIPT0104");
            return rd;
        }
        if (!"00".equals(withdrawReq.getAccountType()) && !"01".equals(withdrawReq.getAccountType())) {
            rd.setCode("EIPT0105");
            return rd;
        }
        if (StringUtil.isEmpty(withdrawReq.getOpenProvince())) {
            rd.setCode("EIPT0109");
            return rd;
        }
        if (StringUtil.isEmpty(withdrawReq.getOpenCity())) {
            rd.setCode("EIPT0110");
            return rd;
        }
        if (withdrawReq.getTradeAmount() == null || withdrawReq.getTradeAmount().compareTo(BigDecimal.ZERO) < 0) {
            rd.setCode("EIPT0106");
            return rd;
        }
        if (withdrawReq.getTradeAmount() == null || !withdrawReq.getCurrency().equals("CNY")) {
            rd.setCode("EIPT0107");
            return rd;
        }
        if (StringUtil.isEmpty(withdrawReq.getBsnType())) {
            rd.setCode("EIPT0108");
            return rd;
        }
        return rd;
    }

    @Override
    public ResultData<String> quickAuthSMSCheck(QuickAuthSMSReq quickAuthSMSReq) {
        ResultData<String> rd = this.baseCheck(quickAuthSMSReq);
        if (!ResCodeEnum.SUCCESS.getCode().equals(rd.getCode())) {
            return rd;
        }
        if (!TranCodeEnum.QUICK_AUTH_SMS.getCode().equals(quickAuthSMSReq.getB_tranCode())) {
            rd.setCode("EIPT0033");
            return rd;
        }
        if (StringUtil.isEmpty(quickAuthSMSReq.getBankName())) {
            rd.setCode("EIPT0101");
            return rd;
        }
        if (StringUtil.isEmpty(quickAuthSMSReq.getAccountNo())) {
            rd.setCode("EIPT0102");
            return rd;
        }
        if (StringUtil.isEmpty(quickAuthSMSReq.getAccountName())) {
            rd.setCode("EIPT0103");
            return rd;
        }
        if (quickAuthSMSReq.getTradeAmount() == null || quickAuthSMSReq.getTradeAmount().compareTo(BigDecimal.ZERO) < 0) {
            rd.setCode("EIPT0106");
            return rd;
        }
        if (StringUtil.isEmpty(quickAuthSMSReq.getCertType())) {
            rd.setCode("EIPT0111");
            return rd;
        }
        if (!"01".equals(quickAuthSMSReq.getCertType())) {
            rd.setCode("EIPT0112");
            return rd;
        }
        if (StringUtil.isEmpty(quickAuthSMSReq.getCertNo())) {
            rd.setCode("EIPT0113");
            return rd;
        }
        if (StringUtil.isEmpty(quickAuthSMSReq.getMobileNo())) {
            rd.setCode("EIPT0114");
            return rd;
        }
        if (!CheckUtil.checkPhone(quickAuthSMSReq.getMobileNo())) {
            rd.setCode("EIPT0115");
            return rd;
        }
        return rd;
    }

    @Override
    public ResultData<String> quickPayCheck(QuickPayReq quickPayReq) {
        ResultData<String> rd = this.baseCheck(quickPayReq);
        if (!ResCodeEnum.SUCCESS.getCode().equals(rd.getCode())) {
            return rd;
        }
        if (!TranCodeEnum.QUICK_PAY.getCode().equals(quickPayReq.getB_tranCode())) {
            rd.setCode("EIPT0033");
            return rd;
        }
        if (StringUtil.isEmpty(quickPayReq.getBankName())) {
            rd.setCode("EIPT0101");
            return rd;
        }
        if (StringUtil.isEmpty(quickPayReq.getAccountNo())) {
            rd.setCode("EIPT0102");
            return rd;
        }
        if (StringUtil.isEmpty(quickPayReq.getAccountName())) {
            rd.setCode("EIPT0103");
            return rd;
        }
        if (quickPayReq.getTradeAmount() == null || quickPayReq.getTradeAmount().compareTo(BigDecimal.ZERO) < 0) {
            rd.setCode("EIPT0106");
            return rd;
        }
        if (StringUtil.isEmpty(quickPayReq.getCertType())) {
            rd.setCode("EIPT0111");
            return rd;
        }
        if (!"01".equals(quickPayReq.getCertType())) {
            rd.setCode("EIPT0112");
            return rd;
        }
        if (StringUtil.isEmpty(quickPayReq.getCertNo())) {
            rd.setCode("EIPT0113");
            return rd;
        }
        if (StringUtil.isEmpty(quickPayReq.getMobileNo())) {
            rd.setCode("EIPT0114");
            return rd;
        }
        if (!CheckUtil.checkPhone(quickPayReq.getMobileNo())) {
            rd.setCode("EIPT0115");
            return rd;
        }
        if (StringUtil.isEmpty(quickPayReq.getMerOrderId())) {
            rd.setCode("EIPT0116");
            return rd;
        }
        if (StringUtil.isEmpty(quickPayReq.getCustId())) {
            rd.setCode("EIPT0117");
            return rd;
        }
        if (StringUtil.isEmpty(quickPayReq.getPhoneToken())) {
            rd.setCode("EIPT0118");
            return rd;
        }
        if (StringUtil.isEmpty(quickPayReq.getPhoneVerCode())) {
            rd.setCode("EIPT0119");
            return rd;
        }
        return rd;
    }

    @Override
    public ResultData<String> verCodeSendCheck(VerCodeSendReq verCodeSendReq) {
        ResultData<String> rd = this.baseCheck(verCodeSendReq);
        if (!ResCodeEnum.SUCCESS.getCode().equals(rd.getCode())) {
            return rd;
        }
        if (!TranCodeEnum.VER_CODE_SEND.getCode().equals(verCodeSendReq.getB_tranCode())) {
            rd.setCode("EIPT0033");
            return rd;
        }
        if (StringUtil.isEmpty(verCodeSendReq.getAccountName())) {
            rd.setCode("EIPT0103");
            return rd;
        }
        if (StringUtil.isEmpty(verCodeSendReq.getMobileNo())) {
            rd.setCode("EIPT0114");
            return rd;
        }
        if (!CheckUtil.checkPhone(verCodeSendReq.getMobileNo())) {
            rd.setCode("EIPT0115");
            return rd;
        }
        return rd;
    }

    @Override
    public ResultData<String> identityAuthCheck(IdentityAuthReq identityAuthReq) {
        ResultData<String> rd = this.baseCheck(identityAuthReq);
        if (!ResCodeEnum.SUCCESS.getCode().equals(rd.getCode())) {
            return rd;
        }
        if (!TranCodeEnum.IDENTITY_AUTH.getCode().equals(identityAuthReq.getB_tranCode())) {
            rd.setCode("EIPT0033");
            return rd;
        }
        if (StringUtil.isEmpty(identityAuthReq.getBankName())) {
            rd.setCode("EIPT0101");
            return rd;
        }
        if (StringUtil.isEmpty(identityAuthReq.getAccountNo())) {
            rd.setCode("EIPT0102");
            return rd;
        }
        if (StringUtil.isEmpty(identityAuthReq.getAccountName())) {
            rd.setCode("EIPT0103");
            return rd;
        }
        if (StringUtil.isEmpty(identityAuthReq.getAccountType())) {
            rd.setCode("EIPT0104");
            return rd;
        }
        if (!"00".equals(identityAuthReq.getAccountType()) && !"01".equals(identityAuthReq.getAccountType())) {
            rd.setCode("EIPT0105");
            return rd;
        }
        if (StringUtil.isEmpty(identityAuthReq.getCertType())) {
            rd.setCode("EIPT0111");
            return rd;
        }
        if (StringUtil.isEmpty(identityAuthReq.getCertNo())) {
            rd.setCode("EIPT0113");
            return rd;
        }
        if (StringUtil.isEmpty(identityAuthReq.getMobileNo())) {
            rd.setCode("EIPT0114");
            return rd;
        }
        if (StringUtil.isEmpty(identityAuthReq.getPhoneVerCode())) {
            rd.setCode("EIPT0119");
            return rd;
        }
        if (StringUtil.isEmpty(identityAuthReq.getPhoneToken())) {
            rd.setCode("EIPT0118");
            return rd;
        }
        return rd;
    }

    @Override
    public ResultData<String> singleTradeQueryCheck(SingleTradeQueryReq singleTradeQueryReq) {
        ResultData<String> rd = this.baseCheck(singleTradeQueryReq);
        if (!ResCodeEnum.SUCCESS.getCode().equals(rd.getCode())) {
            return rd;
        }
        if (!TranCodeEnum.SINGLE_TRADE_QUERY.getCode().equals(singleTradeQueryReq.getB_tranCode())) {
            rd.setCode("EIPT0033");
            return rd;
        }
        if (StringUtil.isEmpty(singleTradeQueryReq.getB_subTranCode())) {
            rd.setCode("EIPT0041");
            return rd;
        }
        if (!SubTranCodeEnum.SUB_01.getCode().equals(singleTradeQueryReq.getB_subTranCode()) && !SubTranCodeEnum.SUB_02.getCode().equals(singleTradeQueryReq.getB_subTranCode())) {
            rd.setCode("EIPT0042");
            return rd;
        }
        if (StringUtil.isEmpty(singleTradeQueryReq.getOrgMerOrderId())) {
            rd.setCode("EIPT0120");
            return rd;
        }
        return rd;
    }

    @Override
    public ResultData<String> balanceQueryCheck(BalanceQueryReq balanceQueryReq) {
        ResultData<String> rd = this.baseCheck(balanceQueryReq);
        if (!ResCodeEnum.SUCCESS.getCode().equals(rd.getCode())) {
            return rd;
        }
        if (!TranCodeEnum.BALANCE_QUERY.getCode().equals(balanceQueryReq.getB_tranCode())) {
            rd.setCode("EIPT0033");
            return rd;
        }
        if (StringUtil.isEmpty(balanceQueryReq.getB_subTranCode())) {
            rd.setCode("EIPT0041");
            return rd;
        }
        if (!SubTranCodeEnum.SUB_01.getCode().equals(balanceQueryReq.getB_subTranCode()) && !SubTranCodeEnum.SUB_02.getCode().equals(balanceQueryReq.getB_subTranCode())) {
            rd.setCode("EIPT0042");
            return rd;
        }
        if (StringUtil.isEmpty(balanceQueryReq.getAcctNo())) {
            rd.setCode("EIPT0121");
            return rd;
        }
        if (SubTranCodeEnum.SUB_02.getCode().equals(balanceQueryReq.getB_subTranCode())) {
            if (StringUtil.isEmpty(balanceQueryReq.getQueryTime())) {
                rd.setCode("EIPT0122");
                return rd;
            }
            if (!CheckUtil.isNumber(balanceQueryReq.getQueryTime(), 14)) {
                rd.setCode("EIPT0123");
                return rd;
            }
        }
        return rd;
    }

    @Override
    public ResultData<String> tradeDetailQueryCheck(TradeDetailQueryReq tradeDetailQueryReq) {
        ResultData<String> rd = this.baseCheck(tradeDetailQueryReq);
        if (!ResCodeEnum.SUCCESS.getCode().equals(rd.getCode())) {
            return rd;
        }
        if (!TranCodeEnum.TRADE_DETAIL_QUERY.getCode().equals(tradeDetailQueryReq.getB_tranCode())) {
            rd.setCode("EIPT0033");
            return rd;
        }
        if (StringUtil.isEmpty(tradeDetailQueryReq.getB_subTranCode())) {
            rd.setCode("EIPT0041");
            return rd;
        }
        if (!SubTranCodeEnum.SUB_01.getCode().equals(tradeDetailQueryReq.getB_subTranCode()) && !SubTranCodeEnum.SUB_02.getCode().equals(tradeDetailQueryReq.getB_subTranCode())) {
            rd.setCode("EIPT0042");
            return rd;
        }
        if (StringUtil.isEmpty(tradeDetailQueryReq.getTranCode())) {
            rd.setCode("EIPT0124");
            return rd;
        }
        if (!(TranCodeEnum.PAY.getCode().equals(tradeDetailQueryReq.getTranCode()) || TranCodeEnum.WITHDRAW.getCode().equals(tradeDetailQueryReq.getTranCode()) || "0".equals(tradeDetailQueryReq.getTranCode()))) {
            rd.setCode("EIPT0125");
            return rd;
        }
        if (StringUtil.isEmpty(tradeDetailQueryReq.getTranState())) {
            rd.setCode("EIPT0126");
            return rd;
        }
        if (!"0".equals(tradeDetailQueryReq.getTranState()) && ResStateEnum.getByCode(tradeDetailQueryReq.getTranState()) == null) {
            rd.setCode("EIPT0127");
            return rd;
        }
        if (StringUtil.isEmpty(tradeDetailQueryReq.getStartTime())) {
            rd.setCode("EIPT0128");
            return rd;
        }
        if (StringUtil.isEmpty(tradeDetailQueryReq.getEndTime())) {
            rd.setCode("EIPT0129");
            return rd;
        }
        if (SubTranCodeEnum.SUB_01.getCode().equals(tradeDetailQueryReq.getB_subTranCode())) {
            if (!CheckUtil.isNumber(tradeDetailQueryReq.getStartTime(), 14)) {
                rd.setCode("EIPT0130");
                return rd;
            }
            if (!CheckUtil.isNumber(tradeDetailQueryReq.getEndTime(), 14)) {
                rd.setCode("EIPT0131");
                return rd;
            }
        } else {
            if (!CheckUtil.isNumber(tradeDetailQueryReq.getStartTime(), 8)) {
                rd.setCode("EIPT0130");
                return rd;
            }
            if (!CheckUtil.isNumber(tradeDetailQueryReq.getEndTime(), 8)) {
                rd.setCode("EIPT0131");
                return rd;
            }
        }
        return rd;
    }

    @Override
    public ResultData<String> moneyRecordQueryCheck(MoneyRecordQueryReq moneyRecordQueryReq) {
        ResultData<String> rd = this.baseCheck(moneyRecordQueryReq);
        if (!ResCodeEnum.SUCCESS.getCode().equals(rd.getCode())) {
            return rd;
        }
        if (!TranCodeEnum.MONEY_RECORD_QUERY.getCode().equals(moneyRecordQueryReq.getB_tranCode())) {
            rd.setCode("EIPT0033");
            return rd;
        }
        if (StringUtil.isEmpty(moneyRecordQueryReq.getB_subTranCode())) {
            rd.setCode("EIPT0041");
            return rd;
        }
        if (!SubTranCodeEnum.SUB_01.getCode().equals(moneyRecordQueryReq.getB_subTranCode()) && !SubTranCodeEnum.SUB_02.getCode().equals(moneyRecordQueryReq.getB_subTranCode())) {
            rd.setCode("EIPT0042");
            return rd;
        }
        if (StringUtil.isEmpty(moneyRecordQueryReq.getAcctNo())) {
            rd.setCode("EIPT0121");
            return rd;
        }
        if (StringUtil.isEmpty(moneyRecordQueryReq.getStartTime())) {
            rd.setCode("EIPT0128");
            return rd;
        }
        if (StringUtil.isEmpty(moneyRecordQueryReq.getEndTime())) {
            rd.setCode("EIPT0129");
            return rd;
        }
        if (SubTranCodeEnum.SUB_01.getCode().equals(moneyRecordQueryReq.getB_subTranCode())) {
            if (!CheckUtil.isNumber(moneyRecordQueryReq.getStartTime(), 14)) {
                rd.setCode("EIPT0130");
                return rd;
            }
            if (!CheckUtil.isNumber(moneyRecordQueryReq.getEndTime(), 14)) {
                rd.setCode("EIPT0131");
                return rd;
            }
        } else {
            if (!CheckUtil.isNumber(moneyRecordQueryReq.getStartTime(), 8)) {
                rd.setCode("EIPT0130");
                return rd;
            }
            if (!CheckUtil.isNumber(moneyRecordQueryReq.getEndTime(), 8)) {
                rd.setCode("EIPT0131");
                return rd;
            }
        }
        return rd;
    }

    @Override
    public ResultData<String> identityAuthQueryCheck(IdentityAuthQueryReq identityAuthQueryReq) {
        ResultData<String> rd = this.baseCheck(identityAuthQueryReq);
        if (!ResCodeEnum.SUCCESS.getCode().equals(rd.getCode())) {
            return rd;
        }
        if (!TranCodeEnum.IDENTITY_AUTH_QUERY.getCode().equals(identityAuthQueryReq.getB_tranCode())) {
            rd.setCode("EIPT0033");
            return rd;
        }
        if (StringUtil.isEmpty(identityAuthQueryReq.getAccountNo())) {
            rd.setCode("EIPT0102");
            return rd;
        }
        if (StringUtil.isEmpty(identityAuthQueryReq.getAccountName())) {
            rd.setCode("EIPT0103");
            return rd;
        }
        if (StringUtil.isEmpty(identityAuthQueryReq.getCertNo())) {
            rd.setCode("EIPT0113");
            return rd;
        }
        if (StringUtil.isEmpty(identityAuthQueryReq.getMobileNo())) {
            rd.setCode("EIPT0114");
            return rd;
        }
        return rd;
    }

    @Override
    public ResultData<String> singleNoticeCheck(SingleNoticeReq singleNoticeReq) {
        ResultData<String> rd = this.baseCheck(singleNoticeReq);
        if (!ResCodeEnum.SUCCESS.getCode().equals(rd.getCode())) {
            return rd;
        }
        if (!TranCodeEnum.SINGLE_NOTICE.getCode().equals(singleNoticeReq.getB_tranCode())) {
            rd.setCode("EIPT0033");
            return rd;
        }
        if (StringUtil.isEmpty(singleNoticeReq.getMsg())) {
            rd.setCode("EIPT0132");
            return rd;
        }
        if (StringUtil.isEmpty(singleNoticeReq.getMac())) {
            rd.setCode("EIPT0133");
            return rd;
        }
        return rd;
    }
}

