/*
 * Decompiled with CFR 0.152.
 */
package com.msyd.gateway.service.impl;

import com.msyd.gateway.bean.payChannel.req.PayChannelBaseReq;
import com.msyd.gateway.bean.payChannel.res.PayChannelBaseRes;
import com.msyd.gateway.bean.req.BaseReq;
import com.msyd.gateway.bean.res.BaseRes;
import com.msyd.gateway.bean.router.BaseRouterCondition;
import com.msyd.gateway.converter.PayChannelConverter;
import com.msyd.gateway.enums.PayChannelEnum;
import com.msyd.gateway.enums.PayChannelMethodEnum;
import com.msyd.gateway.enums.ResCodeEnum;
import com.msyd.gateway.message.ResultData;
import com.msyd.gateway.service.BasePayService;
import com.msyd.gateway.service.PayChannelService;
import com.msyd.gateway.service.impl.BaseService;
import com.msyd.gateway.utils.SpringUtils;
import com.msyd.gateway.utils.StringUtil;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="payChannelService")
public class PayChannelServiceImpl
extends BaseService
implements PayChannelService {
    private static final Log log = LogFactory.getLog(PayChannelServiceImpl.class);

    @Override
    public ResultData<BaseRouterCondition> produceBaseRouterCondition(BaseReq baseReq) {
        log.info((Object)("produceBaseRouterCondition start." + baseReq));
        ResultData<BaseRouterCondition> rd = new ResultData<BaseRouterCondition>();
        log.info((Object)"produceBaseRouterCondition end");
        return rd;
    }

    @Override
    public ResultData<PayChannelEnum> queryPayChannel(BaseRouterCondition routerCondition) {
        log.info((Object)("queryPayChannel start." + routerCondition));
        ResultData<PayChannelEnum> rd = new ResultData<PayChannelEnum>();
        rd.setData(PayChannelEnum.AGENT_PAY);
        log.info((Object)"queryPayChannel end");
        return rd;
    }

    @Override
    public ResultData<PayChannelBaseReq> produceChannelReqBean(BaseReq baseReq, PayChannelEnum payChannelEnum) {
        log.info((Object)"produceChannelReqBean start");
        ResultData<PayChannelBaseReq> rd = new ResultData<PayChannelBaseReq>();
        PayChannelConverter payChannelConverter = (PayChannelConverter)SpringUtils.getBean(payChannelEnum.getConverter());
        PayChannelBaseReq payChannelBaseReq = payChannelConverter.baseToPayChannelReq(baseReq);
        rd.setData(payChannelBaseReq);
        log.info((Object)"produceChannelReqBean end");
        return rd;
    }

    @Override
    public ResultData<PayChannelBaseRes> call(PayChannelBaseReq payChannelBaseReq) {
        log.info((Object)"call start");
        ResultData<PayChannelBaseRes> rd = new ResultData<PayChannelBaseRes>();
        Object o = SpringUtils.getBean(payChannelBaseReq.getB_payChannelEnum().getService());
        PayChannelMethodEnum payChannelMethodEnum = PayChannelMethodEnum.getByCode(payChannelBaseReq.getB_payChannelEnum().getCode() + "_" + payChannelBaseReq.getB_tranCode() + StringUtil.nullToEmptyString(payChannelBaseReq.getB_subTranCode()));
        Method m = null;
        PayChannelBaseRes payChannelBaseRes = null;
        try {
            m = o.getClass().getMethod(payChannelMethodEnum.getMethod(), PayChannelBaseReq.class);
        }
        catch (Exception e) {
            log.error((Object)"\u83b7\u53d6\u6e20\u9053\u4ea4\u6613\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            rd.setCode(ResCodeEnum.ERROR.getCode());
            return rd;
        }
        try {
            payChannelBaseRes = (PayChannelBaseRes)m.invoke(o, payChannelBaseReq);
            payChannelBaseRes.setB_payChannelEnum(payChannelBaseReq.getB_payChannelEnum());
            payChannelBaseRes.setB_tranCode(payChannelBaseReq.getB_tranCode());
            payChannelBaseRes.setB_subTranCode(payChannelBaseReq.getB_subTranCode());
        }
        catch (Exception e) {
            log.error((Object)"\u8c03\u7528\u6e20\u9053\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            rd.setCode(ResCodeEnum.ERROR.getCode());
            return rd;
        }
        rd.setData(payChannelBaseRes);
        log.info((Object)"call end");
        return rd;
    }

    @Override
    public ResultData<BaseRes> payChannelToBaseRes(PayChannelBaseRes payChannelBaseRes, String payOrderId, String payChannelOrderId) {
        log.info((Object)"payChannelToBaseRes start");
        ResultData<BaseRes> rd = new ResultData<BaseRes>();
        PayChannelConverter payChannelConverter = (PayChannelConverter)SpringUtils.getBean(payChannelBaseRes.getB_payChannelEnum().getConverter());
        BaseRes baseRes = payChannelConverter.payChannelToBaseRes(payChannelBaseRes);
        if (!StringUtil.isEmpty(payOrderId)) {
            baseRes.setB_orderId(payOrderId);
        }
        if (!StringUtil.isEmpty(payChannelOrderId)) {
            baseRes.setB_payChannelOrderId(payChannelOrderId);
        }
        rd.setData(baseRes);
        log.info((Object)"payChannelToBaseRes end");
        return rd;
    }

    @Override
    public ResultData<PayChannelBaseRes> pay(PayChannelBaseReq payChannelBaseReq) {
        log.info((Object)"pay start");
        ResultData<PayChannelBaseRes> rd = new ResultData<PayChannelBaseRes>();
        BasePayService basePayService = (BasePayService)SpringUtils.getBean(payChannelBaseReq.getB_payChannelEnum().getService());
        PayChannelBaseRes payChannelBaseRes = null;
        try {
            payChannelBaseRes = basePayService.pay(payChannelBaseReq);
            payChannelBaseRes.setB_payChannelEnum(payChannelBaseReq.getB_payChannelEnum());
            payChannelBaseRes.setB_tranCode(payChannelBaseReq.getB_tranCode());
            payChannelBaseRes.setB_subTranCode(payChannelBaseReq.getB_subTranCode());
        }
        catch (Exception e) {
            log.error((Object)"\u8c03\u7528\u6e20\u9053\u652f\u4ed8\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            rd.setCode(ResCodeEnum.WARNING.getCode());
            return rd;
        }
        rd.setData(payChannelBaseRes);
        log.info((Object)"pay end");
        return rd;
    }

    @Override
    public ResultData<PayChannelBaseRes> withdraw(PayChannelBaseReq payChannelBaseReq) {
        log.info((Object)"withdraw start");
        ResultData<PayChannelBaseRes> rd = new ResultData<PayChannelBaseRes>();
        BasePayService basePayService = (BasePayService)SpringUtils.getBean(payChannelBaseReq.getB_payChannelEnum().getService());
        PayChannelBaseRes payChannelBaseRes = null;
        try {
            payChannelBaseRes = basePayService.withdraw(payChannelBaseReq);
            payChannelBaseRes.setB_payChannelEnum(payChannelBaseReq.getB_payChannelEnum());
            payChannelBaseRes.setB_tranCode(payChannelBaseReq.getB_tranCode());
            payChannelBaseRes.setB_subTranCode(payChannelBaseReq.getB_subTranCode());
        }
        catch (Exception e) {
            log.error((Object)"\u8c03\u7528\u6e20\u9053\u63d0\u73b0\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            rd.setCode(ResCodeEnum.WARNING.getCode());
            return rd;
        }
        rd.setData(payChannelBaseRes);
        log.info((Object)"withdraw end");
        return rd;
    }

    @Override
    public ResultData<PayChannelBaseRes> quickAuthSMS(PayChannelBaseReq payChannelBaseReq) {
        log.info((Object)"quickAuthSMS start");
        ResultData<PayChannelBaseRes> rd = new ResultData<PayChannelBaseRes>();
        BasePayService basePayService = (BasePayService)SpringUtils.getBean(payChannelBaseReq.getB_payChannelEnum().getService());
        PayChannelBaseRes payChannelBaseRes = null;
        try {
            payChannelBaseRes = basePayService.quickAuthSMS(payChannelBaseReq);
            payChannelBaseRes.setB_payChannelEnum(payChannelBaseReq.getB_payChannelEnum());
            payChannelBaseRes.setB_tranCode(payChannelBaseReq.getB_tranCode());
            payChannelBaseRes.setB_subTranCode(payChannelBaseReq.getB_subTranCode());
        }
        catch (Exception e) {
            log.error((Object)"\u8c03\u7528\u6e20\u9053\u5feb\u6377\u9274\u6743\u77ed\u4fe1\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            rd.setCode(ResCodeEnum.WARNING.getCode());
            return rd;
        }
        rd.setData(payChannelBaseRes);
        log.info((Object)"quickAuthSMS end");
        return rd;
    }

    @Override
    public ResultData<PayChannelBaseRes> quickPay(PayChannelBaseReq payChannelBaseReq) {
        log.info((Object)"quickPay start");
        ResultData<PayChannelBaseRes> rd = new ResultData<PayChannelBaseRes>();
        BasePayService basePayService = (BasePayService)SpringUtils.getBean(payChannelBaseReq.getB_payChannelEnum().getService());
        PayChannelBaseRes payChannelBaseRes = null;
        try {
            payChannelBaseRes = basePayService.quickPay(payChannelBaseReq);
            payChannelBaseRes.setB_payChannelEnum(payChannelBaseReq.getB_payChannelEnum());
            payChannelBaseRes.setB_tranCode(payChannelBaseReq.getB_tranCode());
            payChannelBaseRes.setB_subTranCode(payChannelBaseReq.getB_subTranCode());
        }
        catch (Exception e) {
            log.error((Object)"\u8c03\u7528\u6e20\u9053\u5feb\u6377\u5145\u503c\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            rd.setCode(ResCodeEnum.WARNING.getCode());
            return rd;
        }
        rd.setData(payChannelBaseRes);
        log.info((Object)"quickPay end");
        return rd;
    }

    @Override
    public ResultData<PayChannelBaseRes> verCodeSend(PayChannelBaseReq payChannelBaseReq) {
        log.info((Object)"verCodeSend start");
        ResultData<PayChannelBaseRes> rd = new ResultData<PayChannelBaseRes>();
        BasePayService basePayService = (BasePayService)SpringUtils.getBean(payChannelBaseReq.getB_payChannelEnum().getService());
        PayChannelBaseRes payChannelBaseRes = null;
        try {
            payChannelBaseRes = basePayService.verCodeSend(payChannelBaseReq);
            payChannelBaseRes.setB_payChannelEnum(payChannelBaseReq.getB_payChannelEnum());
            payChannelBaseRes.setB_tranCode(payChannelBaseReq.getB_tranCode());
            payChannelBaseRes.setB_subTranCode(payChannelBaseReq.getB_subTranCode());
        }
        catch (Exception e) {
            log.error((Object)"\u8c03\u7528\u6e20\u9053\u9a8c\u8bc1\u7801\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            rd.setCode(ResCodeEnum.WARNING.getCode());
            return rd;
        }
        rd.setData(payChannelBaseRes);
        log.info((Object)"verCodeSend end");
        return rd;
    }

    @Override
    public ResultData<PayChannelBaseRes> identityAuth(PayChannelBaseReq payChannelBaseReq) {
        log.info((Object)"identityAuth start");
        ResultData<PayChannelBaseRes> rd = new ResultData<PayChannelBaseRes>();
        BasePayService basePayService = (BasePayService)SpringUtils.getBean(payChannelBaseReq.getB_payChannelEnum().getService());
        PayChannelBaseRes payChannelBaseRes = null;
        try {
            payChannelBaseRes = basePayService.identityAuth(payChannelBaseReq);
            payChannelBaseRes.setB_payChannelEnum(payChannelBaseReq.getB_payChannelEnum());
            payChannelBaseRes.setB_tranCode(payChannelBaseReq.getB_tranCode());
            payChannelBaseRes.setB_subTranCode(payChannelBaseReq.getB_subTranCode());
        }
        catch (Exception e) {
            log.error((Object)"\u8c03\u7528\u6e20\u9053\u9a8c\u8bc1\u7801\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            rd.setCode(ResCodeEnum.WARNING.getCode());
            return rd;
        }
        rd.setData(payChannelBaseRes);
        log.info((Object)"identityAuth end");
        return rd;
    }

    @Override
    public ResultData<PayChannelBaseRes> singleTradeQuery(PayChannelBaseReq payChannelBaseReq) {
        log.info((Object)"singleTradeQuery start");
        ResultData<PayChannelBaseRes> rd = new ResultData<PayChannelBaseRes>();
        BasePayService basePayService = (BasePayService)SpringUtils.getBean(payChannelBaseReq.getB_payChannelEnum().getService());
        PayChannelBaseRes payChannelBaseRes = null;
        try {
            payChannelBaseRes = basePayService.singleTradeQuery(payChannelBaseReq);
            payChannelBaseRes.setB_payChannelEnum(payChannelBaseReq.getB_payChannelEnum());
            payChannelBaseRes.setB_tranCode(payChannelBaseReq.getB_tranCode());
            payChannelBaseRes.setB_subTranCode(payChannelBaseReq.getB_subTranCode());
        }
        catch (Exception e) {
            log.error((Object)"\u5355\u7b14\u4ea4\u6613\u7ed3\u679c\u67e5\u8be2\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            rd.setCode(ResCodeEnum.WARNING.getCode());
            return rd;
        }
        rd.setData(payChannelBaseRes);
        log.info((Object)"singleTradeQuery end");
        return rd;
    }

    @Override
    public ResultData<PayChannelBaseRes> balanceQuery(PayChannelBaseReq payChannelBaseReq) {
        log.info((Object)"balanceQuery start");
        ResultData<PayChannelBaseRes> rd = new ResultData<PayChannelBaseRes>();
        BasePayService basePayService = (BasePayService)SpringUtils.getBean(payChannelBaseReq.getB_payChannelEnum().getService());
        PayChannelBaseRes payChannelBaseRes = null;
        try {
            log.info((Object)("payChannelBaseReq=" + payChannelBaseReq));
            payChannelBaseRes = basePayService.balanceQuery(payChannelBaseReq);
            log.info((Object)("payChannelBaseRes=" + payChannelBaseRes));
            payChannelBaseRes.setB_payChannelEnum(payChannelBaseReq.getB_payChannelEnum());
            payChannelBaseRes.setB_tranCode(payChannelBaseReq.getB_tranCode());
            payChannelBaseRes.setB_subTranCode(payChannelBaseReq.getB_subTranCode());
        }
        catch (Exception e) {
            log.error((Object)"\u4f59\u989d\u67e5\u8be2\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            rd.setCode(ResCodeEnum.ERROR.getCode());
            return rd;
        }
        rd.setData(payChannelBaseRes);
        log.info((Object)"balanceQuery end");
        return rd;
    }

    @Override
    public ResultData<PayChannelBaseRes> tradeDetailQuery(PayChannelBaseReq payChannelBaseReq) {
        log.info((Object)"tradeDetailQuery start");
        ResultData<PayChannelBaseRes> rd = new ResultData<PayChannelBaseRes>();
        BasePayService basePayService = (BasePayService)SpringUtils.getBean(payChannelBaseReq.getB_payChannelEnum().getService());
        PayChannelBaseRes payChannelBaseRes = null;
        try {
            log.info((Object)("payChannelBaseReq=" + payChannelBaseReq));
            payChannelBaseRes = basePayService.tradeDetailQuery(payChannelBaseReq);
            log.info((Object)("payChannelBaseRes=" + payChannelBaseRes));
            payChannelBaseRes.setB_payChannelEnum(payChannelBaseReq.getB_payChannelEnum());
            payChannelBaseRes.setB_tranCode(payChannelBaseReq.getB_tranCode());
            payChannelBaseRes.setB_subTranCode(payChannelBaseReq.getB_subTranCode());
        }
        catch (Exception e) {
            log.error((Object)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            rd.setCode(ResCodeEnum.ERROR.getCode());
            return rd;
        }
        rd.setData(payChannelBaseRes);
        log.info((Object)"tradeDetailQuery end");
        return rd;
    }

    @Override
    public ResultData<PayChannelBaseRes> moneyRecordQuery(PayChannelBaseReq payChannelBaseReq) {
        log.info((Object)"moneyRecordQuery start");
        ResultData<PayChannelBaseRes> rd = new ResultData<PayChannelBaseRes>();
        BasePayService basePayService = (BasePayService)SpringUtils.getBean(payChannelBaseReq.getB_payChannelEnum().getService());
        PayChannelBaseRes payChannelBaseRes = null;
        try {
            log.info((Object)("payChannelBaseReq=" + payChannelBaseReq));
            payChannelBaseRes = basePayService.moneyRecordQuery(payChannelBaseReq);
            log.info((Object)("payChannelBaseRes=" + payChannelBaseRes));
            payChannelBaseRes.setB_payChannelEnum(payChannelBaseReq.getB_payChannelEnum());
            payChannelBaseRes.setB_tranCode(payChannelBaseReq.getB_tranCode());
            payChannelBaseRes.setB_subTranCode(payChannelBaseReq.getB_subTranCode());
        }
        catch (Exception e) {
            log.error((Object)"\u8d44\u91d1\u6d41\u6c34\u67e5\u8be2\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            rd.setCode(ResCodeEnum.ERROR.getCode());
            return rd;
        }
        rd.setData(payChannelBaseRes);
        log.info((Object)"moneyRecordQuery end");
        return rd;
    }

    @Override
    public ResultData<PayChannelBaseRes> identityAuthQuery(PayChannelBaseReq payChannelBaseReq) {
        log.info((Object)"identityAuthQuery start");
        ResultData<PayChannelBaseRes> rd = new ResultData<PayChannelBaseRes>();
        BasePayService basePayService = (BasePayService)SpringUtils.getBean(payChannelBaseReq.getB_payChannelEnum().getService());
        PayChannelBaseRes payChannelBaseRes = null;
        try {
            log.info((Object)("payChannelBaseReq=" + payChannelBaseReq));
            payChannelBaseRes = basePayService.identityAuthQuery(payChannelBaseReq);
            log.info((Object)("payChannelBaseRes=" + payChannelBaseRes));
            payChannelBaseRes.setB_payChannelEnum(payChannelBaseReq.getB_payChannelEnum());
            payChannelBaseRes.setB_tranCode(payChannelBaseReq.getB_tranCode());
            payChannelBaseRes.setB_subTranCode(payChannelBaseReq.getB_subTranCode());
        }
        catch (Exception e) {
            log.error((Object)"\u5b9e\u540d\u8eab\u4efd\u8ba4\u8bc1\u67e5\u8be2\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            rd.setCode(ResCodeEnum.ERROR.getCode());
            return rd;
        }
        rd.setData(payChannelBaseRes);
        log.info((Object)"identityAuthQuery end");
        return rd;
    }

    @Override
    public ResultData<PayChannelBaseRes> singleNotice(PayChannelBaseReq payChannelBaseReq) {
        log.info((Object)"singleNotice start");
        ResultData<PayChannelBaseRes> rd = new ResultData<PayChannelBaseRes>();
        BasePayService basePayService = (BasePayService)SpringUtils.getBean(payChannelBaseReq.getB_payChannelEnum().getService());
        PayChannelBaseRes payChannelBaseRes = null;
        try {
            log.info((Object)("payChannelBaseReq=" + payChannelBaseReq));
            payChannelBaseRes = basePayService.singleNotice(payChannelBaseReq);
            log.info((Object)("payChannelBaseRes=" + payChannelBaseRes));
            payChannelBaseRes.setB_payChannelEnum(payChannelBaseReq.getB_payChannelEnum());
            payChannelBaseRes.setB_tranCode(payChannelBaseReq.getB_tranCode());
            payChannelBaseRes.setB_subTranCode(payChannelBaseReq.getB_subTranCode());
        }
        catch (Exception e) {
            log.error((Object)"\u5355\u7b14\u4ea4\u6613\u7ed3\u679c\u901a\u77e5\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            rd.setCode(ResCodeEnum.ERROR.getCode());
            return rd;
        }
        rd.setData(payChannelBaseRes);
        log.info((Object)"singleNotice end");
        return rd;
    }
}

