/*
 * Decompiled with CFR 0.152.
 */
package com.msyd.gateway.service.impl;

import com.msds.dealAgentCollPay.bean.CP0006_MsgInfo;
import com.msds.dealAgentCollPay.bean.CP0032_MsgInfo;
import com.msds.dealAgentCollPay.bean.TradeMsgInfo;
import com.msyd.gateway.bean.payChannel.req.AgentPayReq;
import com.msyd.gateway.bean.payChannel.req.PayChannelBaseReq;
import com.msyd.gateway.bean.payChannel.res.AgentPayRes;
import com.msyd.gateway.bean.payChannel.res.PayChannelBaseRes;
import com.msyd.gateway.bean.req.BaseReq;
import com.msyd.gateway.bean.req.PayReq;
import com.msyd.gateway.bean.req.QuickPayReq;
import com.msyd.gateway.bean.req.WithdrawReq;
import com.msyd.gateway.bean.res.BaseRes;
import com.msyd.gateway.dao.map.GatewayPayOrderMapper;
import com.msyd.gateway.dao.model.GatewayPayOrder;
import com.msyd.gateway.dao.model.GatewayPayOrderExample;
import com.msyd.gateway.enums.PayChannelEnum;
import com.msyd.gateway.enums.ResStateEnum;
import com.msyd.gateway.enums.TradeApiEnum;
import com.msyd.gateway.service.PayOrderService;
import com.msyd.gateway.service.impl.BaseService;
import com.msyd.gateway.utils.DateUtil;
import com.msyd.gateway.utils.OrderIdGenerator;
import com.msyd.gateway.utils.StringUtil;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="payOrderService")
public class PayOrderServiceImpl
extends BaseService
implements PayOrderService {
    @Override
    public int addPayOrder(GatewayPayOrder record) {
        GatewayPayOrderMapper gatewayPayOrderMapper = (GatewayPayOrderMapper)this.writableSQLSession.getMapper(GatewayPayOrderMapper.class);
        int count = gatewayPayOrderMapper.insert(record);
        return count;
    }

    @Override
    public int updatePayOrder(GatewayPayOrder record) {
        GatewayPayOrderMapper gatewayPayOrderMapper = (GatewayPayOrderMapper)this.writableSQLSession.getMapper(GatewayPayOrderMapper.class);
        int count = gatewayPayOrderMapper.updateByPrimaryKeySelective(record);
        return count;
    }

    @Override
    public GatewayPayOrder produceAddPayOrder(BaseReq baseReq, PayChannelEnum payChannelEnum, PayChannelBaseReq payChannelBaseReq) {
        GatewayPayOrder record = new GatewayPayOrder();
        record.setPayOrderId(OrderIdGenerator.producePayOrderId(baseReq.getB_merchantNo()));
        record.setMerOrderId(baseReq.getB_merOrderId());
        record.setMerchantNo(baseReq.getB_merchantNo());
        record.setTranCode(baseReq.getB_tranCode());
        record.setSubTranCode(StringUtil.nullToEmptyString(baseReq.getB_subTranCode()));
        record.setClientTime(DateUtil.getDateByStr(baseReq.getB_clientDate() + baseReq.getB_clientTime()));
        record.setRemark(StringUtil.nullToEmptyString(baseReq.getB_remark()));
        TradeApiEnum tae = TradeApiEnum.getByCode(baseReq.getB_tranCode());
        if (TradeApiEnum.PAY.equals((Object)tae)) {
            PayReq payReq = (PayReq)baseReq;
            AgentPayReq agentPayReq = (AgentPayReq)payChannelBaseReq;
            record.setBankName(payReq.getBankName());
            record.setAccountNo(payReq.getAccountNo());
            record.setAccountName(payReq.getAccountName());
            record.setTradeAmount(payReq.getTradeAmount());
            record.setCurrency(payReq.getCurrency());
            record.setPayChannelCode(payChannelEnum.getCode());
            record.setPayChannelName(payChannelEnum.getName());
            record.setPayChannelOrderId(agentPayReq.getHead().getBussflowno());
            record.setCreateTime(new Date());
        } else if (TradeApiEnum.WITHDRAW.equals((Object)tae)) {
            WithdrawReq withdrawReq = (WithdrawReq)baseReq;
            AgentPayReq agentPayReq = (AgentPayReq)payChannelBaseReq;
            record.setBankName(withdrawReq.getBankName());
            record.setAccountNo(withdrawReq.getAccountNo());
            record.setAccountName(withdrawReq.getAccountName());
            record.setTradeAmount(withdrawReq.getTradeAmount());
            record.setCurrency(withdrawReq.getCurrency());
            record.setPayChannelCode(payChannelEnum.getCode());
            record.setPayChannelName(payChannelEnum.getName());
            record.setPayChannelOrderId(agentPayReq.getHead().getBussflowno());
            record.setCreateTime(new Date());
        } else if (TradeApiEnum.QUICK_PAY.equals((Object)tae)) {
            QuickPayReq quickPayReq = (QuickPayReq)baseReq;
            AgentPayReq agentPayReq = (AgentPayReq)payChannelBaseReq;
            record.setBankName(quickPayReq.getBankName());
            record.setAccountNo(quickPayReq.getAccountNo());
            record.setAccountName(quickPayReq.getAccountName());
            record.setTradeAmount(quickPayReq.getTradeAmount());
            record.setCurrency("CNY");
            record.setPayChannelCode(payChannelEnum.getCode());
            record.setPayChannelName(payChannelEnum.getName());
            record.setPayChannelOrderId(agentPayReq.getHead().getBussflowno());
            record.setCreateTime(new Date());
        } else {
            record = null;
        }
        return record;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public GatewayPayOrder produceUpdatePayOrder(String payOrderId, PayChannelBaseRes payChannelBaseRes, BaseRes baseRes) {
        GatewayPayOrder record = new GatewayPayOrder();
        record.setPayOrderId(payOrderId);
        if (!PayChannelEnum.AGENT_PAY.equals((Object)payChannelBaseRes.getB_payChannelEnum())) return null;
        TradeApiEnum tae = TradeApiEnum.getByCode(payChannelBaseRes.getB_tranCode());
        if (TradeApiEnum.PAY.equals((Object)tae)) {
            TradeMsgInfo tradeMsgInfo = (TradeMsgInfo)((AgentPayRes)payChannelBaseRes).getReturnObj();
            Date d = new Date();
            record.setPayChannelResCode(tradeMsgInfo.getRespcode());
            record.setPayChannelResMsg(tradeMsgInfo.getRespmsg());
            record.setPayChannelState(tradeMsgInfo.getTranState());
            record.setServerTime(d);
            record.setResCode(baseRes.getB_resCode());
            record.setResMsg(baseRes.getB_resMsg());
            record.setState(baseRes.getB_state());
            record.setUpdateTime(d);
            return record;
        } else if (TradeApiEnum.WITHDRAW.equals((Object)tae)) {
            TradeMsgInfo tradeMsgInfo = (TradeMsgInfo)((AgentPayRes)payChannelBaseRes).getReturnObj();
            Date d = new Date();
            record.setPayChannelResCode(tradeMsgInfo.getRespcode());
            record.setPayChannelResMsg(tradeMsgInfo.getRespmsg());
            record.setPayChannelState(tradeMsgInfo.getTranState());
            record.setServerTime(d);
            record.setResCode(baseRes.getB_resCode());
            record.setResMsg(baseRes.getB_resMsg());
            record.setState(baseRes.getB_state());
            record.setUpdateTime(d);
            return record;
        } else if (TradeApiEnum.QUICK_AUTH_SMS.equals((Object)tae)) {
            TradeMsgInfo tradeMsgInfo = (TradeMsgInfo)((AgentPayRes)payChannelBaseRes).getReturnObj();
            Date d = new Date();
            record.setPayChannelResCode(tradeMsgInfo.getRespcode());
            record.setPayChannelResMsg(tradeMsgInfo.getRespmsg());
            record.setPayChannelState(tradeMsgInfo.getTranState());
            record.setServerTime(d);
            record.setResCode(baseRes.getB_resCode());
            record.setResMsg(baseRes.getB_resMsg());
            record.setState(baseRes.getB_state());
            record.setUpdateTime(d);
            return record;
        } else if (TradeApiEnum.QUICK_PAY.equals((Object)tae)) {
            TradeMsgInfo tradeMsgInfo = (TradeMsgInfo)((AgentPayRes)payChannelBaseRes).getReturnObj();
            Date d = new Date();
            record.setPayChannelResCode(tradeMsgInfo.getRespcode());
            record.setPayChannelResMsg(tradeMsgInfo.getRespmsg());
            record.setPayChannelState(tradeMsgInfo.getTranState());
            record.setServerTime(d);
            record.setResCode(baseRes.getB_resCode());
            record.setResMsg(baseRes.getB_resMsg());
            record.setState(baseRes.getB_state());
            record.setUpdateTime(d);
            return record;
        } else if (TradeApiEnum.VER_CODE_SEND.equals((Object)tae)) {
            CP0032_MsgInfo msgInfo = (CP0032_MsgInfo)((AgentPayRes)payChannelBaseRes).getReturnObj();
            Date d = new Date();
            record.setServerTime(d);
            record.setResCode(baseRes.getB_resCode());
            record.setResMsg(baseRes.getB_resMsg());
            record.setState(baseRes.getB_state());
            record.setUpdateTime(d);
            record.setRemark(msgInfo.getPhoneToken() + "," + msgInfo.getPhoneVerCode());
            return record;
        } else if (TradeApiEnum.IDENTITY_AUTH.equals((Object)tae)) {
            TradeMsgInfo tradeMsgInfo = (TradeMsgInfo)((AgentPayRes)payChannelBaseRes).getReturnObj();
            Date d = new Date();
            record.setPayChannelResCode(tradeMsgInfo.getRespcode());
            record.setPayChannelResMsg(tradeMsgInfo.getRespmsg());
            record.setPayChannelState(tradeMsgInfo.getTranState());
            record.setServerTime(d);
            record.setResCode(baseRes.getB_resCode());
            record.setResMsg(baseRes.getB_resMsg());
            record.setState(baseRes.getB_state());
            record.setUpdateTime(d);
            return record;
        } else {
            if (!TradeApiEnum.SINGLE_NOTICE.equals((Object)tae)) return null;
            CP0006_MsgInfo msgInfo = (CP0006_MsgInfo)((AgentPayRes)payChannelBaseRes).getReturnObj();
            Date d = new Date();
            record.setPayChannelResCode(msgInfo.getRespcode());
            record.setPayChannelResMsg(msgInfo.getRespmsg());
            record.setPayChannelState(msgInfo.getTranState());
            record.setServerTime(d);
            record.setResCode(baseRes.getB_resCode());
            record.setResMsg(baseRes.getB_resMsg());
            record.setState(baseRes.getB_state());
            record.setUpdateTime(d);
        }
        return record;
    }

    @Override
    public List<GatewayPayOrder> queryByMerOrderIdAndTranCode(String merOrderId, String tranCode, String subTranCode) {
        GatewayPayOrderMapper gatewayPayOrderMapper = (GatewayPayOrderMapper)this.readonlySQLSession.getMapper(GatewayPayOrderMapper.class);
        GatewayPayOrderExample example = new GatewayPayOrderExample();
        GatewayPayOrderExample.Criteria criteria = example.createCriteria();
        criteria.andMerOrderIdEqualTo(merOrderId);
        criteria.andTranCodeEqualTo(tranCode);
        if (!StringUtil.isEmpty(subTranCode)) {
            criteria.andSubTranCodeEqualTo(subTranCode);
        }
        List<GatewayPayOrder> lst = gatewayPayOrderMapper.selectByExample(example);
        return lst;
    }

    @Override
    public List<GatewayPayOrder> queryByMerOrderId(String merOrderId) {
        GatewayPayOrderMapper gatewayPayOrderMapper = (GatewayPayOrderMapper)this.readonlySQLSession.getMapper(GatewayPayOrderMapper.class);
        GatewayPayOrderExample example = new GatewayPayOrderExample();
        GatewayPayOrderExample.Criteria criteria = example.createCriteria();
        criteria.andMerOrderIdEqualTo(merOrderId);
        List<GatewayPayOrder> lst = gatewayPayOrderMapper.selectByExample(example);
        return lst;
    }

    @Override
    public List<GatewayPayOrder> queryByPayChannelOrderId(String payChannelOrderId) {
        GatewayPayOrderMapper gatewayPayOrderMapper = (GatewayPayOrderMapper)this.readonlySQLSession.getMapper(GatewayPayOrderMapper.class);
        GatewayPayOrderExample example = new GatewayPayOrderExample();
        GatewayPayOrderExample.Criteria criteria = example.createCriteria();
        criteria.andPayChannelOrderIdEqualTo(payChannelOrderId);
        List<GatewayPayOrder> lst = gatewayPayOrderMapper.selectByExample(example);
        return lst;
    }

    @Override
    public int updatePayOrderWithState(GatewayPayOrder record) {
        GatewayPayOrderMapper gatewayPayOrderMapper = (GatewayPayOrderMapper)this.readonlySQLSession.getMapper(GatewayPayOrderMapper.class);
        GatewayPayOrderExample example = new GatewayPayOrderExample();
        GatewayPayOrderExample.Criteria criteria = example.createCriteria();
        criteria.andStateNotEqualTo(ResStateEnum.S.getCode());
        criteria.andStateNotEqualTo(ResStateEnum.E.getCode());
        int cnt = gatewayPayOrderMapper.updateByExampleSelective(record, example);
        return cnt;
    }
}

