/*
 * Decompiled with CFR 0.152.
 */
package com.msyd.gateway.utils;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="springUtils")
public final class SpringUtils
implements ApplicationContextAware,
DisposableBean {
    private static ApplicationContext applicationContext;
    public static final String ApplicationContextRoot = "applicationContext/";
    public static final String ApplicationContextPath = "applicationContext/startupContext.xml";

    private SpringUtils() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        SpringUtils.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        applicationContext = null;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getBean(String name) {
        Assert.hasText((String)name);
        if (applicationContext != null) return applicationContext.getBean(name);
        Class<SpringUtils> clazz = SpringUtils.class;
        synchronized (SpringUtils.class) {
            if (applicationContext != null) return applicationContext.getBean(name);
            String[] configLocations = new String[]{ApplicationContextPath};
            applicationContext = new ClassPathXmlApplicationContext(configLocations);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return applicationContext.getBean(name);
        }
    }

    public static <T> T getBean(String name, Class<T> type) {
        Assert.hasText((String)name);
        Assert.notNull(type);
        return (T)applicationContext.getBean(name, type);
    }
}

