/*
 * Decompiled with CFR 0.152.
 */
package com.msyd.gateway.utils;

import com.msyd.gateway.bean.req.BaseReq;
import com.msyd.gateway.bean.res.BaseRes;
import com.msyd.gateway.enums.ResCodeEnum;
import com.msyd.gateway.enums.TradeApiEnum;
import com.msyd.gateway.message.ResultData;
import com.msyd.gateway.utils.DateUtil;
import com.msyd.gateway.utils.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TradeBeanUtil {
    private static final Log logger = LogFactory.getLog(TradeBeanUtil.class);

    public static <T extends BaseRes> T queryResClass(String tranCode) {
        try {
            if (StringUtil.isEmpty(tranCode)) {
                logger.info((Object)"TradeBeanUtil.queryResClass() \u4ea4\u6613\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                return null;
            }
            TradeApiEnum apiEnum = TradeApiEnum.getByCode(tranCode);
            if (apiEnum == null) {
                logger.info((Object)("TradeBeanUtil.queryResClass() \u83b7\u53d6\u4ea4\u6613TradeApiEnum\u5931\u8d25\uff0c\u8bf7\u786e\u5b9a\u4ea4\u6613\u7801\u5df2\u914d\u7f6e\u5230TradeApiEnum\uff0ctranCode:" + tranCode));
                return null;
            }
            Class<?> clazz = apiEnum.getResClass();
            if (clazz != null) {
                return (T)((BaseRes)clazz.newInstance());
            }
        }
        catch (Exception e) {
            logger.error((Object)String.format("\u53d6\u4e1a\u52a1Bean\u5bf9\u8c61\u5f02\u5e38\u3002tranCode = %s", tranCode), (Throwable)e);
        }
        return null;
    }

    public static <T extends BaseRes> T queryResClassByReqClass(Class<?> reqClass) {
        try {
            if (reqClass == null) {
                logger.info((Object)"TradeBeanUtil.queryResClassByReqClass() \u8bf7\u6c42\u7c7b\u4e3a\u7a7a");
                return null;
            }
            TradeApiEnum apiEnum = TradeApiEnum.getByReqClass(reqClass);
            if (apiEnum == null) {
                logger.info((Object)("TradeBeanUtil.queryResClassByReqClass() \u83b7\u53d6\u4ea4\u6613TradeApiEnum\u5931\u8d25\uff0c\u8bf7\u6c42\u7c7b" + reqClass));
                return null;
            }
            Class<?> clazz = apiEnum.getResClass();
            if (clazz != null) {
                return (T)((BaseRes)clazz.newInstance());
            }
        }
        catch (Exception e) {
            logger.error((Object)String.format("\u53d6\u4e1a\u52a1Bean\u5bf9\u8c61\u5f02\u5e38\u3002reqClass = %s", reqClass), (Throwable)e);
        }
        return null;
    }

    public static <O, T extends BaseRes> T produceResErr(BaseReq baseReq, ResultData<O> rd) {
        T resBean = TradeBeanUtil.produceRetComm(baseReq);
        ((BaseRes)resBean).setB_resCode(rd.getCode());
        ((BaseRes)resBean).setB_resMsg(rd.getMsg());
        return resBean;
    }

    public static <O, T extends BaseRes> T produceResCommErr(BaseReq baseReq) {
        T resBean = TradeBeanUtil.produceRetComm(baseReq);
        ((BaseRes)resBean).setB_resCode(ResCodeEnum.ERROR.getCode());
        ((BaseRes)resBean).setB_resMsg(ResCodeEnum.ERROR.getMsg());
        return resBean;
    }

    public static <O, T extends BaseRes> T produceResCommWarn(BaseReq baseReq) {
        T resBean = TradeBeanUtil.produceRetComm(baseReq);
        ((BaseRes)resBean).setB_resCode(ResCodeEnum.WARNING.getCode());
        ((BaseRes)resBean).setB_resMsg(ResCodeEnum.WARNING.getMsg());
        return resBean;
    }

    public static <T extends BaseRes> T produceRetComm(BaseReq baseReq) {
        T resBean = TradeBeanUtil.queryResClass(baseReq.getB_tranCode());
        if (resBean == null && (resBean = TradeBeanUtil.queryResClassByReqClass(baseReq.getClass())) == null) {
            logger.error((Object)"\u53d6\u8fd4\u56debean\u5931\u8d25");
            return null;
        }
        ((BaseRes)resBean).setB_merchantNo(baseReq.getB_merchantNo());
        ((BaseRes)resBean).setB_merOrderId(baseReq.getB_merOrderId());
        ((BaseRes)resBean).setB_tranCode(baseReq.getB_tranCode());
        ((BaseRes)resBean).setB_subTranCode(baseReq.getB_subTranCode());
        String sNowEnd = DateUtil.getNowDateString("yyyyMMddHHmmss");
        ((BaseRes)resBean).setB_serverDate(sNowEnd.substring(0, 8));
        ((BaseRes)resBean).setB_serverTime(sNowEnd.substring(8));
        return resBean;
    }

    public static <T extends BaseRes> void setRetComm(BaseReq baseReq, T t) {
        t.setB_merchantNo(baseReq.getB_merchantNo());
        t.setB_merOrderId(baseReq.getB_merOrderId());
        t.setB_tranCode(baseReq.getB_tranCode());
        t.setB_subTranCode(baseReq.getB_subTranCode());
        String sNowEnd = DateUtil.getNowDateString("yyyyMMddHHmmss");
        t.setB_serverDate(sNowEnd.substring(0, 8));
        t.setB_serverTime(sNowEnd.substring(8));
    }
}

