/*
 * Decompiled with CFR 0.152.
 */
package com.realpersist.gef.command;

import com.realpersist.gef.model.Column;
import com.realpersist.gef.model.Table;
import org.eclipse.gef.commands.Command;

public class ColumnTransferCommand
extends Command {
    private Column columnToMove;
    private Column columnAfter;
    private Table originalTable;
    private Table newTable;
    private int oldIndex;
    private int newIndex;

    public ColumnTransferCommand(Column columnToMove, Column columnAfter, Table originalTable, Table newTable, int oldIndex, int newIndex) {
        this.columnToMove = columnToMove;
        this.columnAfter = columnAfter;
        this.originalTable = originalTable;
        this.newTable = newTable;
        this.oldIndex = oldIndex;
        this.newIndex = newIndex;
    }

    public boolean canExecute() {
        return this.originalTable.getColumns().size() > 1;
    }

    public void execute() {
        this.originalTable.removeColumn(this.columnToMove);
        this.newTable.addColumn(this.columnToMove, this.newIndex);
    }

    public void undo() {
        this.newTable.removeColumn(this.columnToMove);
        this.originalTable.addColumn(this.columnToMove, this.oldIndex);
    }
}

