/*
 * Decompiled with CFR 0.152.
 */
package com.realpersist.gef.command;

import com.realpersist.gef.model.Relationship;
import com.realpersist.gef.model.Schema;
import com.realpersist.gef.model.Table;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class DeleteTableCommand
extends Command {
    private Table table;
    private Schema schema;
    private int index = -1;
    private List foreignKeyRelationships = new ArrayList();
    private List primaryKeyRelationships = new ArrayList();
    private Rectangle bounds;

    private void deleteRelationships(Table t) {
        Relationship r;
        this.foreignKeyRelationships.addAll(t.getForeignKeyRelationships());
        int i = 0;
        while (i < this.foreignKeyRelationships.size()) {
            r = (Relationship)this.foreignKeyRelationships.get(i);
            r.getPrimaryKeyTable().removePrimaryKeyRelationship(r);
            t.removeForeignKeyRelationship(r);
            ++i;
        }
        this.primaryKeyRelationships.addAll(t.getPrimaryKeyRelationships());
        i = 0;
        while (i < this.primaryKeyRelationships.size()) {
            r = (Relationship)this.primaryKeyRelationships.get(i);
            r.getForeignKeyTable().removeForeignKeyRelationship(r);
            t.removePrimaryKeyRelationship(r);
            ++i;
        }
    }

    public void execute() {
        this.primExecute();
    }

    protected void primExecute() {
        this.deleteRelationships(this.table);
        this.index = this.schema.getTables().indexOf(this.table);
        this.schema.removeTable(this.table);
    }

    public void redo() {
        this.primExecute();
    }

    private void restoreRelationships() {
        Relationship r;
        int i = 0;
        while (i < this.foreignKeyRelationships.size()) {
            r = (Relationship)this.foreignKeyRelationships.get(i);
            r.getForeignKeyTable().addForeignKeyRelationship(r);
            r.getPrimaryKeyTable().addPrimaryKeyRelationship(r);
            ++i;
        }
        this.foreignKeyRelationships.clear();
        i = 0;
        while (i < this.primaryKeyRelationships.size()) {
            r = (Relationship)this.primaryKeyRelationships.get(i);
            r.getForeignKeyTable().addForeignKeyRelationship(r);
            r.getPrimaryKeyTable().addPrimaryKeyRelationship(r);
            ++i;
        }
        this.primaryKeyRelationships.clear();
    }

    public void setTable(Table a) {
        this.table = a;
    }

    public void setSchema(Schema sa) {
        this.schema = sa;
    }

    public void undo() {
        this.schema.addTable(this.table, this.index);
        this.restoreRelationships();
        this.table.modifyBounds(this.bounds);
    }

    public void setOriginalBounds(Rectangle bounds) {
        this.bounds = bounds;
    }
}

