/*
 * Decompiled with CFR 0.152.
 */
package com.realpersist.gef.command;

import com.realpersist.gef.model.Relationship;
import com.realpersist.gef.model.Table;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class ReconnectForeignKeyCommand
extends Command {
    protected Table sourceForeignKey;
    protected Table targetPrimaryKey;
    protected Relationship relationship;
    protected Table oldSourceForeignKey;

    public boolean canExecute() {
        boolean returnVal = true;
        Table primaryKeyTable = this.relationship.getPrimaryKeyTable();
        if (primaryKeyTable.equals(this.sourceForeignKey)) {
            returnVal = false;
        } else {
            List relationships = this.sourceForeignKey.getForeignKeyRelationships();
            int i = 0;
            while (i < relationships.size()) {
                Relationship relationship = (Relationship)relationships.get(i);
                if (relationship.getPrimaryKeyTable().equals(this.targetPrimaryKey) && relationship.getForeignKeyTable().equals(this.sourceForeignKey)) {
                    returnVal = false;
                    break;
                }
                ++i;
            }
        }
        return returnVal;
    }

    public void execute() {
        if (this.sourceForeignKey != null) {
            this.oldSourceForeignKey.removeForeignKeyRelationship(this.relationship);
            this.relationship.setForeignKeyTable(this.sourceForeignKey);
            this.sourceForeignKey.addForeignKeyRelationship(this.relationship);
        }
    }

    public Table getSourceForeignKey() {
        return this.sourceForeignKey;
    }

    public void setSourceForeignKey(Table sourceForeignKey) {
        this.sourceForeignKey = sourceForeignKey;
    }

    public Table getTargetPrimaryKey() {
        return this.targetPrimaryKey;
    }

    public void setTargetPrimaryKey(Table targetPrimaryKey) {
        this.targetPrimaryKey = targetPrimaryKey;
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public void setRelationship(Relationship relationship) {
        this.relationship = relationship;
        this.targetPrimaryKey = relationship.getPrimaryKeyTable();
        this.oldSourceForeignKey = relationship.getForeignKeyTable();
    }

    public void undo() {
        this.sourceForeignKey.removeForeignKeyRelationship(this.relationship);
        this.relationship.setForeignKeyTable(this.oldSourceForeignKey);
        this.oldSourceForeignKey.addForeignKeyRelationship(this.relationship);
    }
}

