/*
 * Decompiled with CFR 0.152.
 */
package com.realpersist.gef.command;

import com.realpersist.gef.model.Relationship;
import com.realpersist.gef.model.Table;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class ReconnectPrimaryKeyCommand
extends Command {
    protected Table sourceForeignKey;
    protected Table targetPrimaryKey;
    protected Relationship relationship;
    protected Table oldTargetPrimaryKey;

    public boolean canExecute() {
        boolean returnVal = true;
        Table foreignKeyTable = this.relationship.getForeignKeyTable();
        if (foreignKeyTable.equals(this.targetPrimaryKey)) {
            returnVal = false;
        } else {
            List relationships = this.targetPrimaryKey.getPrimaryKeyRelationships();
            int i = 0;
            while (i < relationships.size()) {
                Relationship relationship = (Relationship)relationships.get(i);
                if (relationship.getForeignKeyTable().equals(this.sourceForeignKey) && relationship.getPrimaryKeyTable().equals(this.targetPrimaryKey)) {
                    returnVal = false;
                    break;
                }
                ++i;
            }
        }
        return returnVal;
    }

    public void execute() {
        if (this.targetPrimaryKey != null) {
            this.oldTargetPrimaryKey.removePrimaryKeyRelationship(this.relationship);
            this.relationship.setPrimaryKeyTable(this.targetPrimaryKey);
            this.targetPrimaryKey.addPrimaryKeyRelationship(this.relationship);
        }
    }

    public Table getSourceForeignKey() {
        return this.sourceForeignKey;
    }

    public void setSourceForeignKey(Table sourceForeignKey) {
        this.sourceForeignKey = sourceForeignKey;
    }

    public Table getTargetPrimaryKey() {
        return this.targetPrimaryKey;
    }

    public void setTargetPrimaryKey(Table targetPrimaryKey) {
        this.targetPrimaryKey = targetPrimaryKey;
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public void setRelationship(Relationship relationship) {
        this.relationship = relationship;
        this.oldTargetPrimaryKey = relationship.getPrimaryKeyTable();
        this.sourceForeignKey = relationship.getForeignKeyTable();
    }

    public void undo() {
        this.targetPrimaryKey.removePrimaryKeyRelationship(this.relationship);
        this.relationship.setPrimaryKeyTable(this.oldTargetPrimaryKey);
        this.oldTargetPrimaryKey.addPrimaryKeyRelationship(this.relationship);
    }
}

