/*
 * Decompiled with CFR 0.152.
 */
package com.realpersist.gef.command;

import com.realpersist.gef.model.Relationship;
import com.realpersist.gef.model.Table;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class RelationshipCreateCommand
extends Command {
    protected Relationship relationship;
    protected Table foreignTable;
    protected Table primaryTable;

    public boolean canExecute() {
        boolean returnValue = true;
        if (this.foreignTable.equals(this.primaryTable)) {
            returnValue = false;
        } else {
            if (this.primaryTable == null) {
                return false;
            }
            List relationships = this.primaryTable.getPrimaryKeyRelationships();
            int i = 0;
            while (i < relationships.size()) {
                Relationship currentRelationship = (Relationship)relationships.get(i);
                if (currentRelationship.getForeignKeyTable().equals(this.foreignTable)) {
                    returnValue = false;
                    break;
                }
                ++i;
            }
        }
        return returnValue;
    }

    public void execute() {
        this.relationship = new Relationship(this.foreignTable, this.primaryTable);
    }

    public Table getForeignTable() {
        return this.foreignTable;
    }

    public Table getPrimaryTable() {
        return this.primaryTable;
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public void redo() {
        this.foreignTable.addForeignKeyRelationship(this.relationship);
        this.primaryTable.addPrimaryKeyRelationship(this.relationship);
    }

    public void setForeignTable(Table foreignTable) {
        this.foreignTable = foreignTable;
    }

    public void setPrimaryTable(Table primaryTable) {
        this.primaryTable = primaryTable;
    }

    public void setRelationship(Relationship relationship) {
        this.relationship = relationship;
    }

    public void undo() {
        this.foreignTable.removeForeignKeyRelationship(this.relationship);
        this.primaryTable.removePrimaryKeyRelationship(this.relationship);
    }
}

