/*
 * Decompiled with CFR 0.152.
 */
package com.realpersist.gef.directedit;

import com.realpersist.gef.directedit.ValidationMessageHandler;
import com.realpersist.gef.model.ColumnType;
import org.eclipse.jface.viewers.ICellEditorValidator;

public class ColumnNameTypeCellEditorValidator
implements ICellEditorValidator {
    private ValidationMessageHandler handler;

    public ColumnNameTypeCellEditorValidator(ValidationMessageHandler validationMessageHandler) {
        this.handler = validationMessageHandler;
    }

    public String isValid(Object value) {
        String string = (String)value;
        String name = null;
        String type = null;
        int colonIndex = string.indexOf(58);
        if (colonIndex >= 0) {
            name = string.substring(0, colonIndex);
            if (string.length() > colonIndex + 1) {
                type = string.substring(colonIndex + 1);
            }
        }
        if (name != null && type != null) {
            if (ColumnType.hasType(type)) {
                return this.unsetMessageText();
            }
            if (name.indexOf(" ") != -1) {
                String text = "Column name should not include the space character";
                return this.setMessageText(text);
            }
            String text = "Invalid type: permissible types are: " + ColumnType.getTypes();
            return this.setMessageText(text);
        }
        String text = "Invalid format for text entry. Needs [name]:[type] format";
        return this.setMessageText(text);
    }

    private String unsetMessageText() {
        this.handler.reset();
        return null;
    }

    private String setMessageText(String text) {
        this.handler.setMessageText(text);
        return text;
    }
}

