/*
 * Decompiled with CFR 0.152.
 */
package com.realpersist.gef.directedit;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;

public class ExtendedDirectEditManager
extends DirectEditManager {
    Font figureFont;
    protected VerifyListener verifyListener;
    protected Label label;
    protected String originalValue;
    private boolean committing = false;
    private ICellEditorValidator validator = null;

    public ExtendedDirectEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator, Label label, ICellEditorValidator validator) {
        super(source, editorType, locator);
        this.label = label;
        this.originalValue = label.getText();
        this.validator = validator;
    }

    protected void bringDown() {
        Font disposeFont = this.figureFont;
        this.figureFont = null;
        super.bringDown();
        if (disposeFont != null) {
            disposeFont.dispose();
        }
    }

    protected void initCellEditor() {
        Text text = (Text)this.getCellEditor().getControl();
        this.verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                Text text = (Text)ExtendedDirectEditManager.this.getCellEditor().getControl();
                String oldText = text.getText();
                String leftText = oldText.substring(0, event.start);
                String rightText = oldText.substring(event.end, oldText.length());
                GC gc = new GC((Drawable)text);
                if (leftText == null) {
                    leftText = "";
                }
                if (rightText == null) {
                    rightText = "";
                }
                String cfr_ignored_0 = String.valueOf(leftText) + event.text + rightText;
                Point size = gc.textExtent(String.valueOf(leftText) + event.text + rightText);
                gc.dispose();
                if (size.x != 0) {
                    size = text.computeSize(size.x, -1);
                } else {
                    size.x = size.y;
                }
                ExtendedDirectEditManager.this.getCellEditor().getControl().setSize(size.x, size.y);
            }
        };
        text.addVerifyListener(this.verifyListener);
        this.originalValue = this.label.getText();
        this.getCellEditor().setValue((Object)this.originalValue);
        IFigure figure = this.getEditPart().getFigure();
        this.figureFont = figure.getFont();
        FontData data = this.figureFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, data.getHeight());
        this.label.translateToAbsolute((Translatable)fontSize);
        data.setHeight(fontSize.height);
        this.figureFont = new Font(null, data);
        this.getCellEditor().setValidator(this.validator);
        text.setFont(this.figureFont);
        text.selectAll();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void commit() {
        if (this.committing) {
            return;
        }
        this.committing = true;
        try {
            this.getCellEditor().getControl().setVisible(false);
            if (this.isDirty()) {
                CommandStack stack = this.getEditPart().getViewer().getEditDomain().getCommandStack();
                Command command = this.getEditPart().getCommand((Request)this.getDirectEditRequest());
                if (command != null && command.canExecute()) {
                    stack.execute(command);
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.bringDown();
            this.committing = false;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.bringDown();
            this.committing = false;
            return;
        }
    }

    protected void unhookListeners() {
        super.unhookListeners();
        Text text = (Text)this.getCellEditor().getControl();
        text.removeVerifyListener(this.verifyListener);
        this.verifyListener = null;
    }
}

