/*
 * Decompiled with CFR 0.152.
 */
package com.realpersist.gef.editor;

import com.realpersist.gef.action.SchemaContextMenuProvider;
import com.realpersist.gef.editor.ContentCreator;
import com.realpersist.gef.editor.GraphicalViewerCreator;
import com.realpersist.gef.editor.OverviewOutlinePage;
import com.realpersist.gef.editor.PaletteFlyoutPreferences;
import com.realpersist.gef.editor.PaletteViewerCreator;
import com.realpersist.gef.editor.SchemaPaletteViewerProvider;
import com.realpersist.gef.model.Schema;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GEFPlugin;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.SaveAction;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.StackAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class SchemaDiagramEditor
extends GraphicalEditorWithFlyoutPalette
implements CommandStackListener,
ISelectionListener {
    private Schema schema;
    private PropertySheetPage undoablePropertySheetPage;
    private GraphicalViewer graphicalViewer;
    private List editPartActionIDs = new ArrayList();
    private List stackActionIDs = new ArrayList();
    private List editorActionIDs = new ArrayList();
    private OverviewOutlinePage overviewOutlinePage;
    private ActionRegistry actionRegistry;
    private DefaultEditDomain editDomain = new DefaultEditDomain((IEditorPart)this);
    private boolean isDirty;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public SchemaDiagramEditor() {
        this.setEditDomain(this.editDomain);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.getCommandStack().addCommandStackListener((CommandStackListener)this);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.createActions();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.updateActions(this.editPartActionIDs);
    }

    public void commandStackChanged(EventObject event) {
        this.updateActions(this.stackActionIDs);
        this.setDirty(this.getCommandStack().isDirty());
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    public void dispose() {
        this.getCommandStack().removeCommandStackListener((CommandStackListener)this);
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.getActionRegistry().dispose();
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        block37: {
            block36: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.gef.GraphicalViewer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter == clazz) break block36;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.gef.EditPartViewer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter != clazz2) break block37;
            }
            return this.getGraphicalViewer();
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.gef.commands.CommandStack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.getCommandStack();
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.gef.EditDomain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz3) {
            return this.getEditDomain();
        }
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("org.eclipse.gef.ui.actions.ActionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz4) {
            return this.getActionRegistry();
        }
        Class<?> clazz5 = class$5;
        if (clazz5 == null) {
            try {
                clazz5 = class$5 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz5) {
            return this.getPropertySheetPage();
        }
        Class<?> clazz6 = class$6;
        if (clazz6 == null) {
            try {
                clazz6 = class$6 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz6) {
            return this.getOverviewOutlinePage();
        }
        return super.getAdapter(adapter);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(out);
            objectOut.writeObject(this.schema);
            objectOut.close();
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            file.setContents((InputStream)new ByteArrayInputStream(out.toByteArray()), true, false, monitor);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getCommandStack().markSaveLocation();
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    public Schema getSchema() {
        return this.schema;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        IFile file = ((IFileEditorInput)input).getFile();
        try {
            this.setPartName(file.getName());
            InputStream is = file.getContents(true);
            ObjectInputStream ois = new ObjectInputStream(is);
            this.schema = (Schema)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.schema = this.getContent();
        }
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new SchemaPaletteViewerProvider((EditDomain)this.editDomain);
    }

    protected void createGraphicalViewer(Composite parent) {
        IEditorSite editorSite = this.getEditorSite();
        GraphicalViewer viewer = new GraphicalViewerCreator(editorSite).createViewer(parent);
        GraphicalViewerKeyHandler graphicalViewerKeyHandler = new GraphicalViewerKeyHandler(viewer);
        KeyHandler parentKeyHandler = graphicalViewerKeyHandler.setParent(this.getCommonKeyHandler());
        viewer.setKeyHandler(parentKeyHandler);
        this.getEditDomain().addViewer((EditPartViewer)viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        viewer.setContents((Object)this.schema);
        SchemaContextMenuProvider provider = new SchemaContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("com.realpersist.gef.editor.contextmenu", (MenuManager)provider, (ISelectionProvider)viewer);
        this.graphicalViewer = viewer;
    }

    protected KeyHandler getCommonKeyHandler() {
        KeyHandler sharedKeyHandler = new KeyHandler();
        sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)"delete"));
        sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        return sharedKeyHandler;
    }

    protected void setDirty(boolean dirty) {
        if (this.isDirty != dirty) {
            this.isDirty = dirty;
            this.firePropertyChange(257);
        }
    }

    protected void createActions() {
        this.addStackAction((StackAction)new UndoAction((IEditorPart)this));
        this.addStackAction((StackAction)new RedoAction((IEditorPart)this));
        this.addEditPartAction((SelectionAction)new DeleteAction((IWorkbenchPart)this));
        this.addEditorAction((WorkbenchPartAction)new SaveAction((IEditorPart)this));
        this.addEditorAction((WorkbenchPartAction)new PrintAction((IWorkbenchPart)this));
    }

    protected void addEditPartAction(SelectionAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.editPartActionIDs.add(action.getId());
    }

    protected void addStackAction(StackAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.stackActionIDs.add(action.getId());
    }

    protected void addEditorAction(WorkbenchPartAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.editorActionIDs.add(action.getId());
    }

    protected void addAction(IAction action) {
        this.getActionRegistry().registerAction(action);
    }

    protected void updateActions(List actionIds) {
        Iterator ids = actionIds.iterator();
        while (ids.hasNext()) {
            IAction action = this.getActionRegistry().getAction(ids.next());
            if (action == null || !(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    protected ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    protected OverviewOutlinePage getOverviewOutlinePage() {
        RootEditPart rootEditPart;
        if (this.overviewOutlinePage == null && this.getGraphicalViewer() != null && (rootEditPart = this.getGraphicalViewer().getRootEditPart()) instanceof ScalableFreeformRootEditPart) {
            this.overviewOutlinePage = new OverviewOutlinePage((ScalableFreeformRootEditPart)rootEditPart);
        }
        return this.overviewOutlinePage;
    }

    protected PropertySheetPage getPropertySheetPage() {
        if (this.undoablePropertySheetPage == null) {
            this.undoablePropertySheetPage = new PropertySheetPage();
            this.undoablePropertySheetPage.setRootEntry(GEFPlugin.createUndoablePropertySheetEntry((CommandStack)this.getCommandStack()));
        }
        return this.undoablePropertySheetPage;
    }

    protected void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
        this.updateActions(this.editorActionIDs);
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return new PaletteFlyoutPreferences();
    }

    protected PaletteRoot getPaletteRoot() {
        return new PaletteViewerCreator().createPaletteRoot();
    }

    private Schema getContent() {
        return new ContentCreator().getContent();
    }

    private static ImageDescriptor create(String iconPath, String name) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.realpersist.gef.schemaeditor", (String)(String.valueOf(iconPath) + name));
    }
}

