/*
 * Decompiled with CFR 0.152.
 */
package com.realpersist.gef.editor.wizard;

import com.realpersist.gef.editor.ContentCreator;
import com.realpersist.gef.model.Schema;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class SchemaDiagramWizardPage
extends WizardNewFileCreationPage
implements SelectionListener {
    private IWorkbench workbench;
    private Button emptyDiagramButton = null;
    private Button preCreatedButtonDiagram = null;
    private boolean emptyModel = true;

    public SchemaDiagramWizardPage(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("schemaWizardPage", selection);
        this.setTitle("Create Database Schema Diagram");
        this.setDescription("Create the schema database diagram GEF demo");
        this.workbench = aWorkbench;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName("change_me.schema");
        Composite composite = (Composite)this.getControl();
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText("Select Schema Model");
        group.setLayoutData((Object)new GridData(768));
        this.emptyDiagramButton = new Button((Composite)group, 16);
        this.emptyDiagramButton.setText("Empty Schema Model");
        this.emptyDiagramButton.addSelectionListener((SelectionListener)this);
        this.emptyDiagramButton.setSelection(true);
        this.preCreatedButtonDiagram = new Button((Composite)group, 16);
        this.preCreatedButtonDiagram.setText("Pre-created Sample Schema Model");
        this.preCreatedButtonDiagram.addSelectionListener((SelectionListener)this);
        new Label(composite, 0);
        this.setPageComplete(this.validatePage());
    }

    protected InputStream getInitialContents() {
        Schema ld = new Schema(this.getFileName());
        if (!this.emptyModel) {
            ld = new ContentCreator().getContent();
        }
        ByteArrayInputStream bais = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(ld);
            oos.flush();
            oos.close();
            baos.close();
            bais = new ByteArrayInputStream(baos.toByteArray());
            bais.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bais;
    }

    protected boolean validatePage() {
        String fileName;
        boolean result = super.validatePage();
        if (result && !(fileName = this.getFileName()).endsWith(".schema")) {
            result = false;
            this.setErrorMessage("File name must end in .schema");
        }
        return result;
    }

    public boolean finish() {
        IFile newFile = this.createNewFile();
        if (newFile == null) {
            return false;
        }
        try {
            IWorkbenchWindow dwindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = dwindow.getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.emptyDiagramButton) {
            this.emptyModel = true;
        } else if (e.getSource() == this.preCreatedButtonDiagram) {
            this.emptyModel = false;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

