/*
 * Decompiled with CFR 0.152.
 */
package com.realpersist.gef.layout;

import com.realpersist.gef.layout.GraphLayoutManager;
import com.realpersist.gef.layout.GraphXYLayout;
import com.realpersist.gef.model.Schema;
import com.realpersist.gef.part.SchemaDiagramPart;
import com.realpersist.gef.policy.SchemaXYLayoutPolicy;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;

public class DelegatingLayoutManager
implements LayoutManager {
    private SchemaDiagramPart diagram;
    private Map figureToBoundsMap;
    private Map partsToNodeMap;
    private LayoutManager activeLayoutManager;
    private GraphLayoutManager graphLayoutManager;
    private GraphXYLayout xyLayoutManager;

    public DelegatingLayoutManager(SchemaDiagramPart diagram) {
        this.diagram = diagram;
        this.graphLayoutManager = new GraphLayoutManager(diagram);
        this.xyLayoutManager = new GraphXYLayout(diagram);
        this.activeLayoutManager = this.graphLayoutManager;
    }

    public void layout(IFigure container) {
        Schema schema = this.diagram.getSchema();
        if (schema.isLayoutManualDesired()) {
            if (this.activeLayoutManager != this.xyLayoutManager) {
                if (schema.isLayoutManualAllowed()) {
                    this.setLayoutManager(container, (LayoutManager)this.xyLayoutManager);
                    this.activeLayoutManager.layout(container);
                } else if (this.diagram.setTableFigureBounds(true)) {
                    this.setLayoutManager(container, (LayoutManager)this.xyLayoutManager);
                    this.activeLayoutManager.layout(container);
                } else {
                    this.activeLayoutManager.layout(container);
                    this.setLayoutManager(container, (LayoutManager)this.xyLayoutManager);
                }
            } else {
                this.setLayoutManager(container, (LayoutManager)this.xyLayoutManager);
                this.activeLayoutManager.layout(container);
            }
        } else {
            this.setLayoutManager(container, (LayoutManager)this.graphLayoutManager);
            this.activeLayoutManager.layout(container);
        }
    }

    public Object getConstraint(IFigure child) {
        return this.activeLayoutManager.getConstraint(child);
    }

    public Dimension getMinimumSize(IFigure container, int wHint, int hHint) {
        return this.activeLayoutManager.getMinimumSize(container, wHint, hHint);
    }

    public Dimension getPreferredSize(IFigure container, int wHint, int hHint) {
        return this.activeLayoutManager.getPreferredSize(container, wHint, hHint);
    }

    public void invalidate() {
        this.activeLayoutManager.invalidate();
    }

    public void remove(IFigure child) {
        this.activeLayoutManager.remove(child);
    }

    public void setConstraint(IFigure child, Object constraint) {
        this.activeLayoutManager.setConstraint(child, constraint);
    }

    public void setXYLayoutConstraint(IFigure child, Rectangle constraint) {
        this.xyLayoutManager.setConstraint(child, constraint);
    }

    private void setLayoutManager(IFigure container, LayoutManager layoutManager) {
        container.setLayoutManager(layoutManager);
        this.activeLayoutManager = layoutManager;
        if (layoutManager == this.xyLayoutManager) {
            this.diagram.installEditPolicy("LayoutEditPolicy", (EditPolicy)new SchemaXYLayoutPolicy());
        } else {
            this.diagram.installEditPolicy("LayoutEditPolicy", null);
        }
    }

    public LayoutManager getActiveLayoutManager() {
        return this.activeLayoutManager;
    }
}

