/*
 * Decompiled with CFR 0.152.
 */
package com.realpersist.gef.layout;

import com.realpersist.gef.figures.TableFigure;
import com.realpersist.gef.layout.GraphAnimation;
import com.realpersist.gef.layout.NodeJoiningDirectedGraphLayout;
import com.realpersist.gef.part.RelationshipPart;
import com.realpersist.gef.part.SchemaDiagramPart;
import com.realpersist.gef.part.TablePart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;

public class DirectedGraphLayoutVisitor {
    Map partToNodesMap;
    DirectedGraph graph;

    public void layoutDiagram(SchemaDiagramPart diagram) {
        this.partToNodesMap = new HashMap();
        this.graph = new DirectedGraph();
        this.addNodes(diagram);
        if (this.graph.nodes.size() > 0) {
            this.addEdges(diagram);
            new NodeJoiningDirectedGraphLayout().visit(this.graph);
            this.applyResults(diagram);
        }
    }

    protected void addNodes(SchemaDiagramPart diagram) {
        GraphAnimation.recordInitialState(diagram.getFigure());
        diagram.getFigure();
        int i = 0;
        while (i < diagram.getChildren().size()) {
            TablePart tp = (TablePart)diagram.getChildren().get(i);
            this.addNodes(tp);
            ++i;
        }
    }

    protected void addNodes(TablePart tablePart) {
        Node n = new Node((Object)tablePart);
        n.width = tablePart.getFigure().getPreferredSize((int)400, (int)300).width;
        n.height = tablePart.getFigure().getPreferredSize((int)400, (int)300).height;
        n.setPadding(new Insets(10, 8, 10, 12));
        this.partToNodesMap.put(tablePart, n);
        this.graph.nodes.add((Object)n);
    }

    protected void addEdges(SchemaDiagramPart diagram) {
        int i = 0;
        while (i < diagram.getChildren().size()) {
            TablePart tablePart = (TablePart)diagram.getChildren().get(i);
            this.addEdges(tablePart);
            ++i;
        }
    }

    protected void addEdges(TablePart tablePart) {
        List outgoing = tablePart.getSourceConnections();
        int i = 0;
        while (i < outgoing.size()) {
            RelationshipPart relationshipPart = (RelationshipPart)tablePart.getSourceConnections().get(i);
            this.addEdges(relationshipPart);
            ++i;
        }
    }

    protected void addEdges(RelationshipPart relationshipPart) {
        GraphAnimation.recordInitialState((Connection)relationshipPart.getFigure());
        Node source = (Node)this.partToNodesMap.get(relationshipPart.getSource());
        Node target = (Node)this.partToNodesMap.get(relationshipPart.getTarget());
        Edge e = new Edge((Object)relationshipPart, source, target);
        e.weight = 2;
        this.graph.edges.add((Object)e);
        this.partToNodesMap.put(relationshipPart, e);
    }

    protected void applyResults(SchemaDiagramPart diagram) {
        this.applyChildrenResults(diagram);
    }

    protected void applyChildrenResults(SchemaDiagramPart diagram) {
        int i = 0;
        while (i < diagram.getChildren().size()) {
            TablePart tablePart = (TablePart)diagram.getChildren().get(i);
            this.applyResults(tablePart);
            ++i;
        }
    }

    protected void applyOwnResults(SchemaDiagramPart diagram) {
    }

    public void applyResults(TablePart tablePart) {
        Node n = (Node)this.partToNodesMap.get(tablePart);
        TableFigure tableFigure = (TableFigure)tablePart.getFigure();
        Rectangle bounds = new Rectangle(n.x, n.y, tableFigure.getPreferredSize().width, tableFigure.getPreferredSize().height);
        tableFigure.setBounds(bounds);
        int i = 0;
        while (i < tablePart.getSourceConnections().size()) {
            RelationshipPart relationship = (RelationshipPart)tablePart.getSourceConnections().get(i);
            this.applyResults(relationship);
            ++i;
        }
    }

    protected void applyResults(RelationshipPart relationshipPart) {
        Edge e = (Edge)this.partToNodesMap.get(relationshipPart);
        NodeList nodes = e.vNodes;
        PolylineConnection conn = (PolylineConnection)relationshipPart.getConnectionFigure();
        conn.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        if (nodes != null) {
            ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
            int i = 0;
            while (i < nodes.size()) {
                Node vn = nodes.getNode(i);
                int x = vn.x;
                int y = vn.y;
                if (e.isFeedback) {
                    bends.add(new AbsoluteBendpoint(x, y + vn.height));
                    bends.add(new AbsoluteBendpoint(x, y));
                } else {
                    bends.add(new AbsoluteBendpoint(x, y));
                    bends.add(new AbsoluteBendpoint(x, y + vn.height));
                }
                ++i;
            }
            conn.setRoutingConstraint(bends);
        } else {
            conn.setRoutingConstraint((Object)Collections.EMPTY_LIST);
        }
    }
}

