/*
 * Decompiled with CFR 0.152.
 */
package com.realpersist.gef.layout;

import com.realpersist.gef.layout.DummyEdgePart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.internal.graph.GraphVisitor;

public class DummyEdgeCreator
extends GraphVisitor {
    NodeList nodeList;
    EdgeList edgeList;
    DirectedGraph graph;
    List edgesAdded;
    List candidateList;
    int targetNodeIndex;
    boolean cleanNextTime = false;

    public void visit(DirectedGraph g) {
        this.cleanNextTime = true;
        this.init(g);
        this.setDummyEdges();
    }

    private void init(DirectedGraph graph) {
        this.graph = graph;
        this.nodeList = graph.nodes;
        this.edgeList = graph.edges;
        this.edgesAdded = new ArrayList();
    }

    protected void setDummyEdges() {
        Node targetNode = null;
        int nodeCount = this.nodeList.size();
        if (nodeCount > 1) {
            Iterator iter = this.nodeList.iterator();
            while (iter.hasNext()) {
                Node sourceNode = (Node)iter.next();
                if (sourceNode.outgoing.size() != 0 || sourceNode.incoming.size() != 0) continue;
                targetNode = this.findTargetNode(sourceNode);
                Edge edge = this.newDummyEdge(targetNode, sourceNode);
                this.edgesAdded.add(edge);
            }
        }
    }

    private Edge newDummyEdge(Node targetNode, Node sourceNode) {
        DummyEdgePart edgePart = new DummyEdgePart();
        Edge edge = new Edge((Object)edgePart, sourceNode, targetNode);
        edge.weight = 2;
        this.edgeList.add((Object)edge);
        targetNode = sourceNode;
        return edge;
    }

    private Node findTargetNode(Node cantBeThis) {
        Node toReturn;
        if (this.candidateList == null) {
            this.candidateList = new NodeList();
            boolean relationshipFound = false;
            Iterator iter = this.nodeList.iterator();
            while (iter.hasNext()) {
                Node element = (Node)iter.next();
                if (element.incoming.size() + element.outgoing.size() < 1) continue;
                this.candidateList.add(element);
                relationshipFound = true;
            }
            if (!relationshipFound) {
                this.candidateList = this.nodeList;
            } else {
                Comparator comparator = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        Node t1 = (Node)o1;
                        Node t2 = (Node)o2;
                        return t1.incoming.size() - t2.incoming.size();
                    }
                };
                try {
                    Collections.sort(this.candidateList, comparator);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if ((toReturn = this.getNext()) == cantBeThis) {
            toReturn = this.getNext();
        }
        return toReturn;
    }

    private Node getNext() {
        this.targetNodeIndex = this.targetNodeIndex == this.candidateList.size() - 1 ? 0 : ++this.targetNodeIndex;
        return (Node)this.candidateList.get(this.targetNodeIndex);
    }

    protected void removeDummyEdges() {
        Iterator iter = this.edgesAdded.iterator();
        while (iter.hasNext()) {
            Edge edge = (Edge)iter.next();
            this.edgeList.remove((Object)edge);
        }
    }
}

