/*
 * Decompiled with CFR 0.152.
 */
package com.realpersist.gef.layout;

import com.realpersist.gef.layout.DirectedGraphLayoutVisitor;
import com.realpersist.gef.layout.GraphAnimation;
import com.realpersist.gef.part.SchemaDiagramPart;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class GraphLayoutManager
extends AbstractLayout {
    private SchemaDiagramPart diagram;
    private Map figureToBoundsMap;
    private Map partsToNodeMap;

    public GraphLayoutManager(SchemaDiagramPart diagram) {
        this.diagram = diagram;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        container.validate();
        List children = container.getChildren();
        Rectangle result = new Rectangle().setLocation(container.getClientArea().getLocation());
        int i = 0;
        while (i < children.size()) {
            result.union(((IFigure)children.get(i)).getBounds());
            ++i;
        }
        result.resize(container.getInsets().getWidth(), container.getInsets().getHeight());
        return result.getSize();
    }

    public void layout(IFigure container) {
        GraphAnimation.recordInitialState(container);
        if (GraphAnimation.playbackState(container)) {
            return;
        }
        new DirectedGraphLayoutVisitor().layoutDiagram(this.diagram);
        this.diagram.setTableModelBounds();
    }
}

