/*
 * Decompiled with CFR 0.152.
 */
package com.realpersist.gef.model;

import com.realpersist.gef.model.PropertyAwareObject;
import com.realpersist.gef.model.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Schema
extends PropertyAwareObject {
    private String name;
    private ArrayList tables = new ArrayList();
    private Map tablesMap = new HashMap();
    private boolean layoutManualDesired = true;
    private boolean layoutManualAllowed = false;

    public Schema(String name) {
        if (name == null) {
            throw new NullPointerException("Name cannot be null");
        }
        this.name = name;
    }

    public void addTable(Table table) {
        this.tables.add(table);
        this.tablesMap.put(table.getName(), table);
        this.firePropertyChange("CHILD", null, table);
    }

    public void addTable(Table table, int i) {
        this.tables.add(i, table);
        this.tablesMap.put(table.getName(), table);
        this.firePropertyChange("CHILD", null, table);
    }

    public void removeTable(Table table) {
        this.tables.remove(table);
        this.tablesMap.remove(table.getName());
        this.firePropertyChange("CHILD", table, null);
    }

    public Table getTable(String name) {
        return (Table)this.tablesMap.get(name);
    }

    public List getTables() {
        return this.tables;
    }

    public String getName() {
        return this.name;
    }

    public void setLayoutManualAllowed(boolean layoutManualAllowed) {
        this.layoutManualAllowed = layoutManualAllowed;
    }

    public boolean isLayoutManualDesired() {
        return this.layoutManualDesired;
    }

    public void setLayoutManualDesired(boolean layoutManualDesired) {
        this.layoutManualDesired = layoutManualDesired;
        this.firePropertyChange("LAYOUT", null, new Boolean(layoutManualDesired));
    }

    public boolean isLayoutManualAllowed() {
        return this.layoutManualAllowed;
    }
}

