/*
 * Decompiled with CFR 0.152.
 */
package com.realpersist.gef.model;

import com.realpersist.gef.model.Column;
import com.realpersist.gef.model.PropertyAwareObject;
import com.realpersist.gef.model.Relationship;
import com.realpersist.gef.model.Schema;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;

public class Table
extends PropertyAwareObject {
    private Schema schema;
    private String name;
    private ArrayList columns = new ArrayList();
    private Rectangle bounds;
    private ArrayList primaryKeyRelationships = new ArrayList();
    private ArrayList foreignKeyRelationships = new ArrayList();

    public Table() {
    }

    public Table(String name, Schema schema) {
        if (name == null) {
            throw new NullPointerException("Name cannot be null");
        }
        if (schema == null) {
            throw new NullPointerException("Schema cannot be null");
        }
        this.name = name;
        this.schema = schema;
    }

    public void addColumn(Column column) {
        if (this.columns.contains(column)) {
            throw new IllegalArgumentException("Column already present");
        }
        this.columns.add(column);
        this.firePropertyChange("CHILD", null, column);
    }

    public void addColumn(Column column, int index) {
        if (this.columns.contains(column)) {
            throw new IllegalArgumentException("Column already present");
        }
        this.columns.add(index, column);
        this.firePropertyChange("CHILD", null, column);
    }

    public void removeColumn(Column column) {
        this.columns.remove(column);
        this.firePropertyChange("CHILD", column, null);
    }

    public void switchColumn(Column column, int index) {
        this.columns.remove(column);
        this.columns.add(index, column);
        this.firePropertyChange("REORDER", this, column);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public void addForeignKeyRelationship(Relationship table) {
        this.foreignKeyRelationships.add(table);
        this.firePropertyChange("OUTPUT", null, table);
    }

    public void addPrimaryKeyRelationship(Relationship table) {
        this.primaryKeyRelationships.add(table);
        this.firePropertyChange("INPUT", null, table);
    }

    public void removeForeignKeyRelationship(Relationship table) {
        this.foreignKeyRelationships.remove(table);
        this.firePropertyChange("OUTPUT", table, null);
    }

    public void removePrimaryKeyRelationship(Relationship table) {
        this.primaryKeyRelationships.remove(table);
        this.firePropertyChange("INPUT", table, null);
    }

    public void modifyName(String name) {
        String oldName = this.name;
        if (!name.equals(oldName)) {
            this.name = name;
            this.firePropertyChange("NAME", null, name);
        }
    }

    public void modifyBounds(Rectangle bounds) {
        Rectangle oldBounds = this.bounds;
        if (!bounds.equals((Object)oldBounds)) {
            this.bounds = bounds;
            this.firePropertyChange("BOUNDS", null, bounds);
        }
    }

    public String getName() {
        return this.name;
    }

    public List getColumns() {
        return this.columns;
    }

    public List getForeignKeyRelationships() {
        return this.foreignKeyRelationships;
    }

    public List getPrimaryKeyRelationships() {
        return this.primaryKeyRelationships;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        if (this.schema == null || this.name == null) {
            return super.hashCode();
        }
        String schemaName = this.schema.getName();
        return schemaName.hashCode() + this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Table)) {
            return false;
        }
        Table t = (Table)o;
        return this.schema.getName().equals(t.getSchema().getName()) && this.name.equals(t.getName());
    }
}

