/*
 * Decompiled with CFR 0.152.
 */
package com.realpersist.gef.part;

import com.realpersist.gef.model.PropertyAwareObject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public abstract class PropertyAwarePart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    public void activate() {
        super.activate();
        PropertyAwareObject propertyAwareObject = (PropertyAwareObject)this.getModel();
        propertyAwareObject.addPropertyChangeListener(this);
    }

    public void deactivate() {
        super.deactivate();
        PropertyAwareObject propertyAwareObject = (PropertyAwareObject)this.getModel();
        propertyAwareObject.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if ("CHILD".equals(property)) {
            this.handleChildChange(evt);
        }
        if ("REORDER".equals(property)) {
            this.handleReorderChange(evt);
        } else if ("OUTPUT".equals(property)) {
            this.handleOutputChange(evt);
        } else if ("INPUT".equals(property)) {
            this.handleInputChange(evt);
        } else if ("NAME".equals(property)) {
            this.commitNameChange(evt);
        } else if ("BOUNDS".equals(property)) {
            this.handleBoundsChange(evt);
        } else if ("LAYOUT".equals(property)) {
            this.handleLayoutChange(evt);
        }
        if ("NAME".equals(property)) {
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)this.getViewer().getContents();
            IFigure partFigure = graphicalEditPart.getFigure();
            partFigure.getUpdateManager().performUpdate();
        }
    }

    private void handleInputChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        if (!(oldValue != null ^ newValue != null)) {
            throw new IllegalStateException("Exactly one of old or new values must be non-null for INPUT event");
        }
        if (newValue != null) {
            ConnectionEditPart editPart = this.createOrFindConnection(newValue);
            int modelIndex = this.getModelTargetConnections().indexOf(newValue);
            this.addTargetConnection(editPart, modelIndex);
        } else {
            List children = this.getTargetConnections();
            ConnectionEditPart partToRemove = null;
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                ConnectionEditPart part = (ConnectionEditPart)iter.next();
                if (part.getModel() != oldValue) continue;
                partToRemove = part;
                break;
            }
            if (partToRemove != null) {
                this.removeTargetConnection(partToRemove);
            }
        }
        this.getContentPane().revalidate();
    }

    private void handleOutputChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        if (!(oldValue != null ^ newValue != null)) {
            throw new IllegalStateException("Exactly one of old or new values must be non-null for INPUT event");
        }
        if (newValue != null) {
            ConnectionEditPart editPart = this.createOrFindConnection(newValue);
            int modelIndex = this.getModelSourceConnections().indexOf(newValue);
            this.addSourceConnection(editPart, modelIndex);
        } else {
            List children = this.getSourceConnections();
            ConnectionEditPart partToRemove = null;
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                ConnectionEditPart part = (ConnectionEditPart)iter.next();
                if (part.getModel() != oldValue) continue;
                partToRemove = part;
                break;
            }
            if (partToRemove != null) {
                this.removeSourceConnection(partToRemove);
            }
        }
        this.getContentPane().revalidate();
    }

    protected void handleChildChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        if (!(oldValue != null ^ newValue != null)) {
            throw new IllegalStateException("Exactly one of old or new values must be non-null for CHILD event");
        }
        if (newValue != null) {
            EditPart editPart = this.createChild(newValue);
            int modelIndex = this.getModelChildren().indexOf(newValue);
            this.addChild(editPart, modelIndex);
        } else {
            List children = this.getChildren();
            EditPart partToRemove = null;
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                EditPart part = (EditPart)iter.next();
                if (part.getModel() != oldValue) continue;
                partToRemove = part;
                break;
            }
            if (partToRemove != null) {
                this.removeChild(partToRemove);
            }
        }
    }

    protected void handleReorderChange(PropertyChangeEvent evt) {
        this.refreshChildren();
        this.refreshVisuals();
    }

    protected void handleLayoutChange(PropertyChangeEvent evt) {
    }

    protected void handleBoundsChange(PropertyChangeEvent evt) {
    }

    protected void commitNameChange(PropertyChangeEvent evt) {
    }
}

