/*
 * Decompiled with CFR 0.152.
 */
package com.realpersist.gef.part;

import com.realpersist.gef.directedit.ExtendedDirectEditManager;
import com.realpersist.gef.directedit.LabelCellEditorLocator;
import com.realpersist.gef.directedit.TableNameCellEditorValidator;
import com.realpersist.gef.directedit.ValidationMessageHandler;
import com.realpersist.gef.editor.ValidationEnabledGraphicalViewer;
import com.realpersist.gef.figures.EditableLabel;
import com.realpersist.gef.figures.TableFigure;
import com.realpersist.gef.model.Table;
import com.realpersist.gef.part.PropertyAwarePart;
import com.realpersist.gef.part.SchemaDiagramPart;
import com.realpersist.gef.part.connector.BottomAnchor;
import com.realpersist.gef.part.connector.TopAnchor;
import com.realpersist.gef.policy.TableContainerEditPolicy;
import com.realpersist.gef.policy.TableDirectEditPolicy;
import com.realpersist.gef.policy.TableEditPolicy;
import com.realpersist.gef.policy.TableLayoutEditPolicy;
import com.realpersist.gef.policy.TableNodeEditPolicy;
import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;

public class TablePart
extends PropertyAwarePart
implements NodeEditPart {
    protected DirectEditManager manager;
    static /* synthetic */ Class class$0;

    public void activate() {
        super.activate();
    }

    public void deactivate() {
        super.deactivate();
    }

    public Table getTable() {
        return (Table)this.getModel();
    }

    protected List getModelChildren() {
        return this.getTable().getColumns();
    }

    protected List getModelSourceConnections() {
        return this.getTable().getForeignKeyRelationships();
    }

    protected List getModelTargetConnections() {
        return this.getTable().getPrimaryKeyRelationships();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("GraphicalNodeEditPolciy", (EditPolicy)new TableNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new TableLayoutEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new TableContainerEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new TableEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new TableDirectEditPolicy());
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            if (request instanceof DirectEditRequest && !this.directEditHitTest(((DirectEditRequest)request).getLocation().getCopy())) {
                return;
            }
            this.performDirectEdit();
        }
    }

    private boolean directEditHitTest(Point requestLoc) {
        TableFigure figure = (TableFigure)this.getFigure();
        EditableLabel nameLabel = figure.getNameLabel();
        nameLabel.translateToRelative((Translatable)requestLoc);
        return nameLabel.containsPoint(requestLoc);
    }

    protected void performDirectEdit() {
        if (this.manager == null) {
            ValidationEnabledGraphicalViewer viewer = (ValidationEnabledGraphicalViewer)this.getViewer();
            ValidationMessageHandler handler = viewer.getValidationHandler();
            TableFigure figure = (TableFigure)this.getFigure();
            EditableLabel nameLabel = figure.getNameLabel();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.viewers.TextCellEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.manager = new ExtendedDirectEditManager((GraphicalEditPart)this, clazz, new LabelCellEditorLocator(nameLabel), nameLabel, new TableNameCellEditorValidator(handler));
        }
        this.manager.show();
    }

    public void handleNameChange(String value) {
        TableFigure tableFigure = (TableFigure)this.getFigure();
        EditableLabel label = tableFigure.getNameLabel();
        label.setVisible(false);
        this.refreshVisuals();
    }

    public void revertNameChange() {
        TableFigure tableFigure = (TableFigure)this.getFigure();
        EditableLabel label = tableFigure.getNameLabel();
        Table table = this.getTable();
        label.setText(table.getName());
        label.setVisible(true);
        this.refreshVisuals();
    }

    public String toString() {
        return this.getModel().toString();
    }

    protected void commitNameChange(PropertyChangeEvent evt) {
        TableFigure tableFigure = (TableFigure)this.getFigure();
        EditableLabel label = tableFigure.getNameLabel();
        label.setText(this.getTable().getName());
        label.setVisible(true);
        this.refreshVisuals();
    }

    protected void handleBoundsChange(PropertyChangeEvent evt) {
        TableFigure tableFigure = (TableFigure)this.getFigure();
        Rectangle constraint = (Rectangle)evt.getNewValue();
        SchemaDiagramPart parent = (SchemaDiagramPart)this.getParent();
        parent.setLayoutConstraint((EditPart)this, (IFigure)tableFigure, constraint);
    }

    protected IFigure createFigure() {
        Table table = this.getTable();
        EditableLabel label = new EditableLabel(table.getName());
        TableFigure tableFigure = new TableFigure(label);
        return tableFigure;
    }

    protected void refreshVisuals() {
        TableFigure tableFigure = (TableFigure)this.getFigure();
        Point location = tableFigure.getLocation();
        SchemaDiagramPart parent = (SchemaDiagramPart)this.getParent();
        Rectangle constraint = new Rectangle(location.x, location.y, -1, -1);
        parent.setLayoutConstraint((EditPart)this, (IFigure)tableFigure, constraint);
    }

    public IFigure getContentPane() {
        TableFigure figure = (TableFigure)this.getFigure();
        return figure.getColumnsFigure();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new TopAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new TopAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new BottomAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new BottomAnchor(this.getFigure());
    }

    public void setSelected(int value) {
        super.setSelected(value);
        TableFigure tableFigure = (TableFigure)this.getFigure();
        if (value != 0) {
            tableFigure.setSelected(true);
        } else {
            tableFigure.setSelected(false);
        }
        tableFigure.repaint();
    }
}

