/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.ws.comm;

import com.sunyard.ws.comm.Base64Coder;
import com.sunyard.ws.comm.FindMAC;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class License {
    private static boolean haslic = false;
    public static int maxUsers;

    public static boolean haslic() {
        return haslic;
    }

    private PublicKey createPublicKey(String key) throws Exception {
        byte[] keyBytes = new BASE64Decoder().decodeBuffer(key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    private static PrivateKey createPrivateKey(String key) throws Exception {
        byte[] keyBytes = new BASE64Decoder().decodeBuffer(key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    private String getKeyString(Key key) throws Exception {
        byte[] keyBytes = key.getEncoded();
        String s = new BASE64Encoder().encode(keyBytes);
        return s;
    }

    public void createKeyFile(String privateFile, String publicFile) throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        OutputStreamWriter output = null;
        keyPairGen.initialize(1024);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        String publicKeyString = this.getKeyString(publicKey);
        String privateKeyString = this.getKeyString(privateKey);
        output = new OutputStreamWriter((OutputStream)new FileOutputStream(privateFile), "UTF-8");
        output.write(privateKeyString);
        ((Writer)output).close();
        output = new OutputStreamWriter((OutputStream)new FileOutputStream(publicFile), "UTF-8");
        output.write(publicKeyString);
        ((Writer)output).close();
        output = null;
    }

    public String encryptionInfo(String publicKeyFile, String info) throws Exception {
        String temp;
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(publicKeyFile)));
        Cipher cipher = Cipher.getInstance("RSA");
        String publicKeyString = "";
        while ((temp = br.readLine()) != null) {
            publicKeyString = publicKeyString + temp;
        }
        PublicKey publicKey = this.createPublicKey(publicKeyString);
        cipher.init(1, publicKey);
        byte[] enBytes = cipher.doFinal(info.getBytes());
        return new String(Base64Coder.encode(enBytes));
    }

    public static byte[] decryptInfo(String info) throws Exception {
        String temp;
        BufferedReader br = new BufferedReader(new InputStreamReader(License.class.getClassLoader().getResourceAsStream("private.key")));
        Cipher cipher = Cipher.getInstance("RSA");
        String privateKeyString = "";
        while ((temp = br.readLine()) != null) {
            privateKeyString = privateKeyString + temp;
        }
        PrivateKey privateKey = License.createPrivateKey(privateKeyString);
        cipher.init(2, privateKey);
        byte[] deBytes = cipher.doFinal(Base64Coder.decode(info.toCharArray()));
        return deBytes;
    }

    public void createLicense(String productorName, String componentName, String versionNo, String serialNo, String companyName, String email, String expirationDate, String sra, String maxusers, String componentType, String savePath) throws IOException {
        Document xmlDOC = DocumentHelper.createDocument();
        Element root = xmlDOC.addElement(componentName + "-LICENSE");
        Element license = this.createChildElement(root, "LICENSE");
        license.addAttribute("PRODUCTOR", productorName);
        license.addAttribute("COMPONENT", componentName);
        license.addAttribute("VERSION", versionNo);
        license.addAttribute("SERIAL", serialNo);
        license.addAttribute("COMPANY", companyName);
        license.addAttribute("EXPIRATION", expirationDate);
        license.addAttribute("MAXUSERS", maxusers);
        license.addAttribute("COMPONENTTYPE", componentType);
        license.addAttribute("EMAIL", email);
        license.addAttribute("SIGNATURE", sra);
        XMLWriter writer = new XMLWriter((Writer)new FileWriter(savePath));
        writer.write(xmlDOC);
        writer.close();
        writer = null;
    }

    public static Map<String, String> parseLicense() throws DocumentException {
        HashMap<String, String> lic = new HashMap<String, String>();
        SAXReader reader = new SAXReader();
        Document document = reader.read(License.class.getClassLoader().getResourceAsStream("SunECMLic.xml"));
        List licInfo = document.getRootElement().selectNodes("LICENSE");
        List att = null;
        for (Element e : licInfo) {
            att = e.attributes();
            for (Attribute a : att) {
                lic.put(a.getName(), a.getValue());
            }
        }
        return lic;
    }

    private Element createChildElement(Element e, String c) {
        Element child = e.addElement(c);
        return child;
    }

    public static boolean CheckLicense() {
        boolean flag = false;
        FindMAC fm = new FindMAC();
        List<String> mac = fm.macInfo();
        String macLic = null;
        Map<Object, Object> lic = new HashMap();
        try {
            lic = License.parseLicense();
            macLic = new String(License.decryptInfo((String)lic.get("SIGNATURE")));
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        for (String s : mac) {
            String[] macAddress = macLic.split("===");
            try {
                if (!s.equals(macAddress[0])) continue;
                haslic = true;
                flag = true;
                maxUsers = Integer.parseInt(macAddress[1]);
                break;
            }
            catch (NumberFormatException e) {
                flag = false;
            }
        }
        return flag;
    }
}

