/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.ws.utils;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtil<T> {
    private static XStream xStream = new XStream((HierarchicalStreamDriver)new XppDriver(new XmlFriendlyReplacer("_-", "_")));
    private static XStream dexStream = new XStream((HierarchicalStreamDriver)new DomDriver());

    private static String getTypeName(Class type) {
        String nodeName = "";
        XStreamAlias alias = type.getAnnotation(XStreamAlias.class);
        nodeName = alias != null ? alias.value() : type.getSimpleName();
        return nodeName;
    }

    public static <T> String bean2XML(T t) {
        xStream.processAnnotations(t.getClass());
        return xStream.toXML(t).replaceAll("\\n", "").replace("&lt;", "<").replace("&gt;", ">").replace("&quot;", "\"").replaceAll(",", "<<DH>>");
    }

    public static <T> T xml2Bean(String xml, Class type) {
        xml = xml.replaceAll("<<DH>>", ",");
        dexStream.processAnnotations(type);
        Object t = dexStream.fromXML(xml);
        return (T)t;
    }

    public static <T> String list2Xml(List<T> list) {
        StringBuffer sb = new StringBuffer();
        for (T t : list) {
            sb.append(XMLUtil.bean2XML(t)).append("");
        }
        return sb.toString();
    }

    public static <T> List<T> xml2list(String xml, Class type) {
        ArrayList<T> list = new ArrayList<T>();
        String nodeName = XMLUtil.getTypeName(type);
        if (nodeName.equals("Map")) {
            nodeName = "map";
        }
        String[] xmlStrArray = xml.split("<" + nodeName);
        for (int i = 1; i < xmlStrArray.length; ++i) {
            String str = xmlStrArray[i];
            list.add(XMLUtil.xml2Bean("<" + nodeName + str, type));
        }
        return list;
    }

    public static <T> String addHeadRootNode(String str) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<root>").append(str).append("</root>");
        return sb.toString();
    }

    public static <T> String removeHeadRoot(String str) {
        str = str.replaceAll("<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>", "");
        str = str.replaceAll("<root>", "");
        str = str.replaceAll("</root>", "");
        return str;
    }

    public static <T> String removeHeadRoot(String str, String isLogin) {
        if ("isLogin".equals(isLogin)) {
            str = str.replaceAll("<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>", "");
            str = str.replaceAll("<ROOT>", "");
            str = str.replaceAll("</ROOT>", "");
            str = str.replaceAll("<MESSAGE>", "");
            str = str.replaceAll("</MESSAGE>", "");
            return str;
        }
        return XMLUtil.removeHeadRoot(str);
    }
}

